/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemHeatingUnit
extends Item {
    public ItemHeatingUnit(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof OvenBlockEntity && !((OvenBlockEntity)blockEntity).hasPowerUpgrade()) {
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(context.getHand()).shrink(1);
            }
            ((OvenBlockEntity)blockEntity).setHasPowerUpgrade(true);
            if (!level.isClientSide) {
                Balm.getNetworking().sendToTracking((ServerLevel)level, pos, (CustomPacketPayload)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.OVEN_UPGRADE));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        consumer.accept((Component)Component.translatable((String)"tooltip.cookingforblockheads.oven_upgrade").withStyle(ChatFormatting.YELLOW));
        consumer.accept((Component)Component.translatable((String)"tooltip.cookingforblockheads.heating_unit.description").withStyle(ChatFormatting.GRAY));
    }
}

