/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.comparator;

import java.util.Comparator;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.crafting.CraftableWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;

public class ComparatorHunger
implements Comparator<CraftableWithStatus> {
    private final ComparatorName fallback = new ComparatorName();
    private final Player player;

    public ComparatorHunger(Player player) {
        this.player = player;
    }

    @Override
    public int compare(CraftableWithStatus o1, CraftableWithStatus o2) {
        boolean isFirstFood = o1.itemStack().has(DataComponents.FOOD);
        boolean isSecondFood = o2.itemStack().has(DataComponents.FOOD);
        if (!isFirstFood && !isSecondFood) {
            return this.fallback.compare(o1, o2);
        }
        if (!isFirstFood) {
            return 1;
        }
        if (!isSecondFood) {
            return -1;
        }
        int result = CookingForBlockheadsAPI.getFoodStatsProvider().getNutrition(o2.itemStack(), this.player) - CookingForBlockheadsAPI.getFoodStatsProvider().getNutrition(o1.itemStack(), this.player);
        if (result == 0) {
            return this.fallback.compare(o1, o2);
        }
        return result;
    }
}

