/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.slot;

import java.util.Comparator;
import java.util.List;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.AbstractFakeSlot;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;

public class CraftMatrixFakeSlot
extends AbstractFakeSlot {
    private static final float ITEM_SWITCH_TIME = 40.0f;
    private final NonNullList<ItemStack> visibleStacks = NonNullList.create();
    private final KitchenMenu menu;
    private int ingredientIndex;
    private SlotDisplay slotDisplay;
    private float variantTimePassed;
    private int currentVariantIndex;
    private boolean isLocked;
    private boolean missing = true;

    public CraftMatrixFakeSlot(KitchenMenu menu, Container container, int slotId, int x, int y) {
        super(container, slotId, x, y);
        this.menu = menu;
    }

    public void setIngredient(int ingredientIndex, SlotDisplay slotDisplay, ItemStack lockedInput) {
        ItemStack effectiveLockedInput;
        this.ingredientIndex = ingredientIndex;
        SlotDisplay previousIngredient = this.slotDisplay;
        ItemStack itemStack = effectiveLockedInput = this.isLocked ? this.getItem() : ItemStack.EMPTY;
        if (!lockedInput.isEmpty()) {
            effectiveLockedInput = lockedInput;
        }
        this.visibleStacks.clear();
        this.slotDisplay = slotDisplay;
        if (slotDisplay != null) {
            List itemStacks = slotDisplay.resolveForStacks(SlotDisplayContext.fromLevel((Level)this.menu.player.level()));
            for (ItemStack itemStack2 : itemStacks) {
                if (itemStack2.isEmpty()) continue;
                this.visibleStacks.add((Object)itemStack2.copyWithCount(1));
            }
        }
        this.visibleStacks.sort(Comparator.comparing(it -> BuiltInRegistries.ITEM.getKey((Object)it.getItem()).toString()));
        this.variantTimePassed = 0.0f;
        this.currentVariantIndex = previousIngredient != slotDisplay ? 0 : (!this.visibleStacks.isEmpty() ? this.currentVariantIndex % this.visibleStacks.size() : 0);
        this.isLocked = false;
        if (!effectiveLockedInput.isEmpty()) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.visibleStacks.get(i)), (ItemStack)effectiveLockedInput)) continue;
                this.currentVariantIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.variantTimePassed += partialTicks;
            if (this.variantTimePassed >= 40.0f) {
                ++this.currentVariantIndex;
                if (this.currentVariantIndex >= this.visibleStacks.size()) {
                    this.currentVariantIndex = 0;
                }
                this.variantTimePassed = 0.0f;
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return !this.visibleStacks.isEmpty() ? (ItemStack)this.visibleStacks.get(this.currentVariantIndex) : ItemStack.EMPTY;
    }

    @Override
    public boolean hasItem() {
        return !this.visibleStacks.isEmpty();
    }

    public boolean isActive() {
        return !this.visibleStacks.isEmpty();
    }

    public NonNullList<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public ItemStack scrollDisplayListAndLock(int i) {
        this.isLocked = true;
        this.currentVariantIndex += i;
        if (this.currentVariantIndex >= this.visibleStacks.size()) {
            this.currentVariantIndex = 0;
        } else if (this.currentVariantIndex < 0) {
            this.currentVariantIndex = this.visibleStacks.size() - 1;
        }
        return (ItemStack)this.visibleStacks.get(this.currentVariantIndex);
    }

    public ItemStack toggleLock() {
        this.isLocked = !this.isLocked;
        return this.isLocked ? this.getItem() : ItemStack.EMPTY;
    }

    public int getIngredientIndex() {
        return this.ingredientIndex;
    }
}

