/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.server.ServerReloadFinishedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.mixin.RecipeManagerAccessor;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;

public class CookingForBlockheadsRegistry {
    private static final Multimap<ResourceLocation, RecipeHolder<?>> recipesByItemId = ArrayListMultimap.create();
    private static final Multimap<ResourceLocation, RecipeHolder<?>> recipesByGroup = ArrayListMultimap.create();
    private static final List<ISortButton> sortButtons = new ArrayList<ISortButton>();
    private static final Map<ItemStack, Integer> ovenFuelItems = new HashMap<ItemStack, Integer>();
    private static final Map<Class<? extends Recipe<?>>, KitchenRecipeHandler<?, ?>> kitchenRecipeHandlers = new HashMap();

    public static void initialize(BalmEvents events) {
        events.onEvent(ServerReloadFinishedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().getRecipeManager(), (RegistryAccess)event.getServer().registryAccess()));
        events.onEvent(ServerStartedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().getRecipeManager(), (RegistryAccess)event.getServer().registryAccess()));
    }

    private static void reload(RecipeManager recipeManager, RegistryAccess registryAccess) {
        recipesByItemId.clear();
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, RecipeType.CRAFTING);
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, RecipeType.SMELTING);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> void loadRecipesByType(RecipeManager recipeManager, RegistryAccess registryAccess, RecipeType<T> recipeType) {
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        for (RecipeHolder recipeHolder : recipeMap.byType(recipeType)) {
            ItemStack resultItem;
            Recipe recipe;
            Object recipeHandler;
            if (!CookingForBlockheadsRegistry.isEligibleRecipe(recipeHolder) || (recipeHandler = CookingForBlockheadsRegistry.getKitchenRecipeHandler(recipe = recipeHolder.value())) == null || !CookingForBlockheadsRegistry.isEligibleResultItem(resultItem = recipeHandler.predictResultItem((Recipe)recipe))) continue;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)resultItem.getItem());
            recipesByItemId.put((Object)itemId, (Object)recipeHolder);
            List<KitchenRecipeGroup> groups = CookingForBlockheadsRegistry.getGroups();
            block1: for (KitchenRecipeGroup group : groups) {
                for (Ingredient ingredient : group.getChildren()) {
                    if (!ingredient.test(resultItem)) continue;
                    ResourceLocation groupItemId = BuiltInRegistries.ITEM.getKey((Object)group.getParentItem());
                    recipesByGroup.put((Object)groupItemId, (Object)recipeHolder);
                    continue block1;
                }
            }
        }
    }

    public static List<KitchenRecipeGroup> getGroups() {
        return List.of();
    }

    private static boolean isEligibleResultItem(ItemStack itemStack) {
        if (itemStack.is(ModItemTags.EXCLUDED)) {
            return false;
        }
        return itemStack.has(DataComponents.FOOD) || itemStack.is(ModItemTags.FOODS) || itemStack.is(ModItemTags.INGREDIENTS);
    }

    private static <T extends RecipeInput> boolean isEligibleRecipe(RecipeHolder<? extends Recipe<T>> recipe) {
        return !CookingForBlockheadsConfig.getActive().excludedRecipes.contains(recipe.id().location());
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void registerKitchenRecipeHandler(Class<T> recipeType, KitchenRecipeHandler<C, T> handler) {
        kitchenRecipeHandlers.put(recipeType, handler);
    }

    public static <C extends RecipeInput, T extends Recipe<C>, V extends KitchenRecipeHandler<C, T>> V getKitchenRecipeHandler(T recipe) {
        for (Class<Recipe<?>> handlerClass : kitchenRecipeHandlers.keySet()) {
            if (!handlerClass.isAssignableFrom(recipe.getClass())) continue;
            return (V)kitchenRecipeHandlers.get(handlerClass);
        }
        return (V)kitchenRecipeHandlers.get(recipe.getClass());
    }

    public static void addSortButton(ISortButton nameSortButton) {
        sortButtons.add(nameSortButton);
    }

    public static Collection<ISortButton> getSortButtons() {
        return sortButtons;
    }

    public static void addOvenFuel(ItemStack fuelItem, int fuelTime) {
        ovenFuelItems.put(fuelItem, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!ItemStack.isSameItem((ItemStack)entry.getKey(), (ItemStack)itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static Collection<RecipeHolder<?>> getRecipesFor(ItemStack resultItem) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)resultItem.getItem());
        return recipesByItemId.get((Object)itemId);
    }

    public static Collection<? extends RecipeHolder<?>> getRecipesInGroup(ItemStack resultItem) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)resultItem.getItem());
        return recipesByGroup.get((Object)itemId);
    }

    public static Multimap<ResourceLocation, RecipeHolder<?>> getRecipesByItemId() {
        return recipesByItemId;
    }
}

