/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.rechiseled.api.ChiselingRecipeProvider;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class RegistrationChiselingRecipeProvider
extends ChiselingRecipeProvider {
    private final RechiseledRegistrationImpl registration;

    public RegistrationChiselingRecipeProvider(RechiseledRegistrationImpl registration, DataGenerator generator) {
        super(registration.getModid(), generator);
        this.registration = registration;
    }

    @Override
    protected void buildRecipes() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getChiselingEntries().forEach(triple -> this.beginRecipe((ResourceLocation)triple.left()).add(triple.middle() == null ? null : ((ItemLike)((Supplier)triple.middle()).get()).asItem(), triple.right() == null ? null : ((ItemLike)((Supplier)triple.right()).get()).asItem()));
        this.registration.getBlockBuilders().forEach(pair -> {
            RechiseledBlockBuilderImpl builder = (RechiseledBlockBuilderImpl)pair.left();
            RechiseledBlockTypeImpl type = (RechiseledBlockTypeImpl)pair.right();
            if (builder.recipe != null) {
                BlockItem regularItem;
                Object object = type.hasRegularVariant() ? type.getRegularItem() : (regularItem = builder.customRegularVariant != null ? builder.customRegularVariant.get().asItem() : null);
                BlockItem connectingItem = type.hasConnectingVariant() ? type.getConnectingItem() : (builder.customConnectingVariant != null ? builder.customConnectingVariant.get().asItem() : null);
                this.beginRecipe(builder.recipe).add((Item)regularItem, (Item)connectingItem);
            }
        });
    }

    @Override
    public String getName() {
        return "Registration Chiseling Recipe Provider: " + this.registration.getModid();
    }
}

