/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.ScreenBlockRenderer;
import com.supermartijn642.rechiseled.screen.ScreenItemRender;
import com.supermartijn642.rechiseled.screen.ToggleRotationButton;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class EntryPreviewWidget
extends BaseWidget {
    private static final int ROTATION_TIME = 10000;
    private final Supplier<Item> item;
    private final Supplier<Integer> previewMode;
    private float yaw = 0.35f;
    private float pitch = 30.0f;
    private long lastRotationTime;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public EntryPreviewWidget(int x, int y, int width, int height, Supplier<Item> item, Supplier<Integer> previewMode) {
        super(x, y, width, height);
        this.item = item;
        this.previewMode = previewMode;
        this.lastRotationTime = System.currentTimeMillis();
    }

    protected void addWidgets() {
        this.addWidget((Widget)new ToggleRotationButton(this.x, this.y, 11, 11));
        super.addWidgets();
    }

    public Component getNarrationMessage() {
        return null;
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        long now = System.currentTimeMillis();
        Item item = this.item.get();
        int previewMode = this.previewMode.get();
        if (item != null && previewMode >= 0 && previewMode <= 2) {
            if (this.dragging) {
                this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
                this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
                this.mouseStartX = mouseX;
                this.mouseStartY = mouseY;
            } else if (ToggleRotationButton.rotate) {
                this.yaw = (float)((double)this.yaw + (double)(now - this.lastRotationTime) / 10000.0 * 360.0);
            }
            if (item instanceof BlockItem) {
                BlockCapture capture;
                Block block = ((BlockItem)item).getBlock();
                if (previewMode == 0) {
                    capture = new BlockCapture(block);
                } else if (previewMode == 1) {
                    capture = new BlockCapture(block);
                    capture.putBlock(new BlockPos(-1, 0, 0), block);
                    capture.putBlock(new BlockPos(1, 0, 0), block);
                } else {
                    capture = new BlockCapture();
                    for (int i = 0; i < 9; ++i) {
                        capture.putBlock(new BlockPos(i / 3 - 1, i % 3 - 1, 0), block);
                    }
                }
                graphics.nextStratum();
                graphics.submitCustomRendering(this.x, this.y, this.width, this.height, poseStack -> ScreenBlockRenderer.drawBlock(poseStack, capture, (double)this.width / 2.0, (double)this.height / 2.0, this.width, this.yaw, this.pitch, true));
            } else {
                graphics.submitCustomRendering(this.x, this.y, this.width, this.height, poseStack -> ScreenItemRender.drawItem(poseStack, item, (double)this.width / 2.0, (double)this.height / 2.0, this.width, this.yaw, this.pitch, true));
            }
        }
        this.lastRotationTime = now;
        super.render(context, graphics, mouseX, mouseY);
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!(hasBeenHandled |= super.mousePressed(mouseX, mouseY, button, hasBeenHandled)) && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
            return true;
        }
        return hasBeenHandled;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }
}

