/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.BlockCaptureLevel;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenBlockRenderer {
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(PoseStack poseStack, BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0);
        poseStack.mulPose((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale((float)scale, (float)scale, (float)(-scale));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(pitch / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(yaw / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            ScreenBlockRenderer.renderBlock(entry.getKey(), entry.getValue(), poseStack, (MultiBufferSource)bufferSource);
        }
        poseStack.popPose();
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5);
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (MultiBufferSource)bufferSource, (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (BlockAndTintGetter)fakeLevel, (BlockPos)pos, (BlockState)state);
        poseStack.popPose();
    }
}

