/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.justaraftmod.Reference;
import com.mrbysco.justaraftmod.client.ClientHandler;
import com.mrbysco.justaraftmod.client.model.RaftModel;
import com.mrbysco.justaraftmod.client.state.RaftRenderState;
import com.mrbysco.justaraftmod.entities.Raft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RaftRenderer
extends EntityRenderer<Raft, RaftRenderState> {
    private static final ResourceLocation DEFAULT_TEXTURE = Reference.modLoc("textures/entity/raft/oak_raft.png");
    private final RaftModel model;

    public RaftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RaftModel(context.bakeLayer(ClientHandler.RAFT));
        this.shadowRadius = 0.5f;
    }

    public RaftRenderState createRenderState() {
        return new RaftRenderState();
    }

    public void extractRenderState(Raft raft, RaftRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)raft, (EntityRenderState)renderState, partialTick);
        renderState.yRot = raft.getYRot(partialTick);
        renderState.hurtTime = (float)raft.getHurtTime() - partialTick;
        renderState.hurtDir = raft.getHurtDir();
        renderState.damageTime = Math.max(raft.getDamage() - partialTick, 0.0f);
        renderState.bubbleAngle = raft.getBubbleAngle(partialTick);
        renderState.isUnderWater = raft.isUnderWater();
        renderState.rowingTimeLeft = raft.getRowingTime(0, partialTick);
        renderState.rowingTimeRight = raft.getRowingTime(1, partialTick);
        renderState.textureLocation = this.getTextureLocation(raft);
    }

    public void render(RaftRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - renderState.yRot));
        float f = renderState.hurtTime;
        if (f > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin((float)f) * f * renderState.damageTime / 10.0f * (float)renderState.hurtDir));
        }
        if (!Mth.equal((float)renderState.bubbleAngle, (float)0.0f)) {
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(renderState.bubbleAngle * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        this.model.setupAnim(renderState);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(renderState.textureLocation));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(Raft entity) {
        if (entity.getRaftType().getTextureLocation() == null) {
            return DEFAULT_TEXTURE;
        }
        return entity.getRaftType().getTextureLocation();
    }
}

