/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.datagen;

import com.mrbysco.justaraftmod.init.RaftRegistry;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ItemTagsProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class RaftDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new Recipes.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new RaftItemTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new RaftEntityTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new Language(packOutput));
        generator.addProvider(true, (DataProvider)new Models(packOutput));
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            super(provider, recipeOutput);
        }

        protected void buildRecipes() {
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.ACACIA_RAFT, (TagKey<Item>)ItemTags.ACACIA_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.BAMBOO_RAFT, (ItemLike)Items.BAMBOO).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.BIRCH_RAFT, (TagKey<Item>)ItemTags.BIRCH_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.CHERRY_RAFT, (TagKey<Item>)ItemTags.CHERRY_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.DARK_OAK_RAFT, (TagKey<Item>)ItemTags.DARK_OAK_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.JUNGLE_RAFT, (TagKey<Item>)ItemTags.JUNGLE_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.MANGROVE_RAFT, (TagKey<Item>)ItemTags.MANGROVE_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.OAK_RAFT, (TagKey<Item>)ItemTags.OAK_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.SPRUCE_RAFT, (TagKey<Item>)ItemTags.SPRUCE_LOGS).save(this.output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.PALE_OAK_RAFT, (TagKey<Item>)ItemTags.PALE_OAK_LOGS).save(this.output);
        }

        private RecipeBuilder generateRaftRecipe(DeferredHolder<Item, RaftItem> raft, TagKey<Item> logTag) {
            return this.shaped(RecipeCategory.TRANSPORTATION, (ItemLike)raft.get()).pattern("S S").pattern("LLL").pattern("S S").define(Character.valueOf('L'), logTag).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy("has_log", this.has(logTag)).unlockedBy("has_string", this.has(Tags.Items.STRINGS));
        }

        private RecipeBuilder generateRaftRecipe(DeferredHolder<Item, RaftItem> raft, ItemLike log) {
            return this.shaped(RecipeCategory.TRANSPORTATION, (ItemLike)raft.get()).pattern("S S").pattern("LLL").pattern("S S").define(Character.valueOf('L'), log).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy("has_log", this.has(log)).unlockedBy("has_string", this.has(Tags.Items.STRINGS));
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
                super(output, completableFuture);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new Recipes(provider, recipeOutput);
            }

            public String getName() {
                return "Statues Recipes";
            }
        }
    }

    public static class RaftItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> RAFTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"justaraftmod", (String)"rafts"));

        public RaftItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "justaraftmod");
        }

        public void addTags(HolderLookup.Provider provider) {
            this.tag(RAFTS).add((Object[])new Item[]{(Item)RaftRegistry.OAK_RAFT.get(), (Item)RaftRegistry.SPRUCE_RAFT.get(), (Item)RaftRegistry.BIRCH_RAFT.get(), (Item)RaftRegistry.JUNGLE_RAFT.get(), (Item)RaftRegistry.ACACIA_RAFT.get(), (Item)RaftRegistry.DARK_OAK_RAFT.get(), (Item)RaftRegistry.BAMBOO_RAFT.get(), (Item)RaftRegistry.MANGROVE_RAFT.get(), (Item)RaftRegistry.CHERRY_RAFT.get(), (Item)RaftRegistry.PALE_OAK_RAFT.get()});
        }
    }

    public static class RaftEntityTags
    extends EntityTypeTagsProvider {
        public RaftEntityTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "justaraftmod");
        }

        public void addTags(HolderLookup.Provider provider) {
            this.tag(Tags.EntityTypes.BOATS).add(RaftRegistry.RAFT.get());
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "justaraftmod", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.justaraftmod.raft", "Just A Raft Mod");
            this.add("justaraftmod.config.title", "Just Another Raft Config");
            this.addItem((Supplier)RaftRegistry.OAK_RAFT, "Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.SPRUCE_RAFT, "Spruce Log Raft");
            this.addItem((Supplier)RaftRegistry.BIRCH_RAFT, "Birch Log Raft");
            this.addItem((Supplier)RaftRegistry.CHERRY_RAFT, "Cherry Log Raft");
            this.addItem((Supplier)RaftRegistry.JUNGLE_RAFT, "Jungle Log Raft");
            this.addItem((Supplier)RaftRegistry.ACACIA_RAFT, "Acacia Log Raft");
            this.addItem((Supplier)RaftRegistry.DARK_OAK_RAFT, "Dark Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.BAMBOO_RAFT, "Bamboo Raft");
            this.addItem((Supplier)RaftRegistry.MANGROVE_RAFT, "Mangrove Raft");
            this.addItem((Supplier)RaftRegistry.PALE_OAK_RAFT, "Pale Oak Raft");
            this.addEntityType(RaftRegistry.RAFT, "Raft");
            this.addConfig("Server", "Server", "Server settings");
            this.addConfig("SpeedMultiplier", "Speed Multiplier", "Adjusting this setting changes the speed of the raft. (Default: 1.0) [Lower than 1 = slower | higher than 1 = faster]");
            this.addConfig("TurnMultiplier", "Turn Multiplier", "Adjusting this setting changes the speed of turning the raft. (Default: 1.0) [Lower than 1 = slower | higher than 1 = faster]");
            this.addConfig("SlipperyFast", "Slippery Fast", "Changing this to false makes rafts the same speed as on land while on a slippery block. (Default: true)");
            this.addConfig("SinkTheRaft", "Sink The Raft", "Changing this to true makes the raft sink if there's 2 entities on it. (Default: false)");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("justaraftmod.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("justaraftmod.configuration." + path + ".tooltip", description);
            }
        }
    }

    private static class Models
    extends ModelProvider {
        public static final TextureSlot LOG_SIDE = TextureSlot.create((String)"log_side");
        public static final TextureSlot LOG_TOP = TextureSlot.create((String)"log_top");
        public static final ModelTemplate RAFT = ModelTemplates.createItem((String)"justaraftmod:raft_base", (TextureSlot[])new TextureSlot[]{LOG_SIDE, LOG_TOP});

        public Models(PackOutput packOutput) {
            super(packOutput, "justaraftmod");
        }

        protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
            this.createRaft(itemModels, RaftRegistry.ACACIA_RAFT, this.mcLocation("acacia_log").withPrefix("block/"), this.mcLocation("acacia_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.BAMBOO_RAFT, this.mcLocation("bamboo_stalk").withPrefix("block/"), this.mcLocation("bamboo_stalk").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.BIRCH_RAFT, this.mcLocation("birch_log").withPrefix("block/"), this.mcLocation("birch_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.CHERRY_RAFT, this.mcLocation("cherry_log").withPrefix("block/"), this.mcLocation("cherry_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.DARK_OAK_RAFT, this.mcLocation("dark_oak_log").withPrefix("block/"), this.mcLocation("dark_oak_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.JUNGLE_RAFT, this.mcLocation("jungle_log").withPrefix("block/"), this.mcLocation("jungle_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.MANGROVE_RAFT, this.mcLocation("mangrove_log").withPrefix("block/"), this.mcLocation("mangrove_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.OAK_RAFT, this.mcLocation("oak_log").withPrefix("block/"), this.mcLocation("oak_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.SPRUCE_RAFT, this.mcLocation("spruce_log").withPrefix("block/"), this.mcLocation("spruce_log_top").withPrefix("block/"));
            this.createRaft(itemModels, RaftRegistry.PALE_OAK_RAFT, this.mcLocation("pale_oak_log").withPrefix("block/"), this.mcLocation("pale_oak_log_top").withPrefix("block/"));
        }

        private void createRaft(ItemModelGenerators itemModels, DeferredItem<?> deferredItem, ResourceLocation side, ResourceLocation top) {
            ResourceLocation model = RAFT.create(ModelLocationUtils.getModelLocation((Item)((Item)deferredItem.get())), this.getRaftMapping(side, top), itemModels.modelOutput);
            itemModels.itemModelOutput.accept((Item)deferredItem.get(), ItemModelUtils.plainModel((ResourceLocation)model));
        }

        private TextureMapping getRaftMapping(ResourceLocation side, ResourceLocation top) {
            return new TextureMapping().put(LOG_SIDE, side).put(LOG_TOP, top);
        }
    }
}

