/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.entities;

import com.mrbysco.justaraftmod.config.RaftConfig;
import com.mrbysco.justaraftmod.entities.RaftType;
import com.mrbysco.justaraftmod.init.RaftRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class Raft
extends AbstractBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(Raft.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Raft(EntityType<? extends Raft> entityType, Level level) {
        super(entityType, level, () -> Items.STICK);
        this.dropItem = this::getDrop;
    }

    public Raft(Level level, double x, double y, double z) {
        this(RaftRegistry.RAFT.get(), level);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)0);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putString("Type", this.getRaftType().getName());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.setRaftType(RaftType.byName(input.getStringOr("Type", "")));
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0) {
                    if (this.status != AbstractBoat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.isRemoved()) {
                            this.kill(serverLevel);
                            if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                for (int i = 0; i < 3; ++i) {
                                    this.spawnAtLocation(serverLevel, (ItemLike)this.getRaftType().getPlanks());
                                }
                                for (int j = 0; j < 2; ++j) {
                                    this.spawnAtLocation(serverLevel, (ItemLike)Items.STICK);
                                }
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance -= (double)((float)y);
            }
        }
    }

    public void tick() {
        super.tick();
        if (((Boolean)RaftConfig.SERVER.SinkTheRaft.get()).booleanValue() && this.getPassengers().size() > 1) {
            Vec3 motion = this.getDeltaMovement();
            double newY = motion.y - 0.035;
            this.setDeltaMovement(motion.x, newY, motion.z);
        }
    }

    public AbstractBoat.Status getStatus() {
        AbstractBoat.Status boatStatus = this.isUnderwater();
        if (boatStatus != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return boatStatus;
        }
        if (this.checkInWater()) {
            return AbstractBoat.Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = (Boolean)RaftConfig.SERVER.SlipperyFast.get() != false ? f : 0.0f;
            return AbstractBoat.Status.ON_LAND;
        }
        return AbstractBoat.Status.IN_AIR;
    }

    public void floatBoat() {
        double d1 = this.isNoGravity() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float f = 0.05f;
        if (this.oldStatus == AbstractBoat.Status.IN_AIR && this.status != AbstractBoat.Status.IN_AIR && this.status != AbstractBoat.Status.ON_LAND) {
            this.waterLevel = this.getBoundingBox().minY + (double)this.getBbHeight();
            this.setPos(this.getX(), (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101, this.getZ());
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = AbstractBoat.Status.IN_WATER;
        } else {
            if (this.status == AbstractBoat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.getBoundingBox().minY + 0.1) / (double)this.getBbHeight();
                f = 0.9f;
            } else if (this.status == AbstractBoat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                f = 0.9f;
            } else if (this.status == AbstractBoat.Status.UNDER_WATER) {
                d2 = 0.01f;
                f = 0.45f;
            } else if (this.status == AbstractBoat.Status.IN_AIR) {
                f = 0.9f;
            } else if (this.status == AbstractBoat.Status.ON_LAND) {
                f = this.landFriction;
                if (this.getControllingPassenger() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 Vector3d = this.getDeltaMovement();
            this.setDeltaMovement(Vector3d.x * (double)f, Vector3d.y + d1, Vector3d.z * (double)f);
            this.deltaRotation *= f;
            if (d2 > 0.0) {
                Vec3 Vector3d1 = this.getDeltaMovement();
                this.setDeltaMovement(Vector3d1.x, (Vector3d1.y + d2 * 0.06153846016296973) * 0.75, Vector3d1.z);
            }
        }
    }

    public void controlBoat() {
        if (this.isVehicle()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= ((Double)RaftConfig.SERVER.TurnMultiplier.get()).floatValue();
            }
            if (this.inputRight) {
                this.deltaRotation += ((Double)RaftConfig.SERVER.TurnMultiplier.get()).floatValue();
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f * ((Double)RaftConfig.SERVER.SpeedMultiplier.get()).floatValue();
            }
            if (this.inputDown) {
                f -= 0.005f * ((Double)RaftConfig.SERVER.SpeedMultiplier.get()).floatValue();
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    public float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public Item getDrop() {
        if (this.getRaftType() == null) {
            return Items.STICK;
        }
        return (Item)this.getRaftType().getRaft().value();
    }

    public void setRaftType(RaftType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.getId());
    }

    public RaftType getRaftType() {
        return RaftType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    protected double rideHeight(EntityDimensions dimensions) {
        return dimensions.height() * 0.8888889f;
    }
}

