/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.config.CommentedConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BuiltInPackConfig(List<String> defaultPacks, List<String> disabledPacks) implements CommentedConfig<BuiltInPackConfig>
{
    private static BuiltInPackConfig INSTANCE = null;
    public static final BuiltInPackConfig DEFAULT = new BuiltInPackConfig(BuiltInDataPackLoader.getIDs(), List.of());
    public static final Codec<BuiltInPackConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)Codec.STRING).fieldOf("defaultPacks").forGetter(config -> config.defaultPacks), (App)Codec.list((Codec)Codec.STRING).fieldOf("disabledPacks").forGetter(config -> config.disabledPacks)).apply((Applicative)builder, BuiltInPackConfig::new));

    public static void updateConfig() {
        BuiltInPackConfig config = (BuiltInPackConfig)DEFAULT.getConfig();
        ArrayList<String> modifiableList1 = new ArrayList<String>(config.defaultPacks());
        ArrayList<String> modifiableList2 = new ArrayList<String>(config.disabledPacks());
        boolean bl = false;
        if (modifiableList1.retainAll(DEFAULT.defaultPacks())) {
            bl = true;
        }
        if (modifiableList2.retainAll(DEFAULT.defaultPacks())) {
            bl = true;
        }
        for (String item : DEFAULT.defaultPacks()) {
            if (modifiableList1.contains(item) || modifiableList2.contains(item)) continue;
            modifiableList1.add(item);
            bl = true;
        }
        if (bl) {
            config.setInstance(new BuiltInPackConfig(modifiableList1, modifiableList2));
            config.getConfig(false, true);
        }
    }

    @Override
    public String getSubPath() {
        return "cristellib/built_in_packs";
    }

    @Override
    public BuiltInPackConfig getInstance() {
        return INSTANCE;
    }

    @Override
    public BuiltInPackConfig getDefault() {
        return DEFAULT;
    }

    @Override
    public Codec<BuiltInPackConfig> getCodec() {
        return CODEC;
    }

    @Override
    @Nullable
    public HashMap<String, String> getComments() {
        return null;
    }

    @Override
    @NotNull
    public String getHeader() {
        return "This config file makes it possible to disable built-in packs supplied by Cristel Lib.\nTo disable a pack move it from the \"defaultPacks\" list to the \"disabledPacks\" list.\n";
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public void setInstance(BuiltInPackConfig instance) {
        INSTANCE = instance;
    }
}

