/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.neoforge;

import java.util.Optional;
import javax.annotation.Nullable;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModLoadingUtilImpl {
    public static boolean isModLoaded(String modid) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modid);
        }
        return ModLoadingUtilImpl.isModPreLoaded(modid);
    }

    public static boolean isModPreLoaded(String modid) {
        return ModLoadingUtilImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }

    public static Optional<Integer> compare(String modid, String version) {
        if (ModLoadingUtilImpl.isModLoaded(modid)) {
            ModList modList = ModList.get();
            ArtifactVersion modVersion = modList != null ? ((ModContainer)modList.getModContainerById(modid).get()).getModInfo().getVersion() : ModLoadingUtilImpl.getPreLoadedModVersion(modid);
            DefaultArtifactVersion min = new DefaultArtifactVersion(version);
            return Optional.of(modVersion.compareTo((Object)min));
        }
        return Optional.empty();
    }

    public static ArtifactVersion getPreLoadedModVersion(String modid) {
        ModInfo info = ModLoadingUtilImpl.getPreLoadedModInfo(modid);
        if (info == null) {
            throw new RuntimeException("Couldn't find mod: " + modid);
        }
        return info.getVersion();
    }
}

