/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.ItemClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.item.ItemInformationProviderCommon;

public class ItemAction<M extends IModBase>
extends ConfigurableTypeActionRegistry<ItemConfigCommon<M>, Item, M> {
    protected static final List<ItemConfigCommon<?>> MODEL_ENTRIES = Lists.newArrayList();

    @Override
    public void onRegistriesFilled(ItemConfigCommon<M> eConfig) {
        ItemAction.register(eConfig, () -> {
            this.polish(eConfig);
            eConfig.onRegistryRegistered();
            return null;
        });
    }

    public static <M extends IModBase> void handleItemModel(ItemConfigCommon<M> extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(ItemConfigCommon<M> config) {
        ItemClientConfig<M> clientConfig;
        for (ItemStack itemStack : config.getDefaultCreativeTabEntries()) {
            config.getMod().registerDefaultCreativeTabEntry(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        ItemInformationProviderCommon.registerItem((Item)config.getInstance());
        if (!config.getMod().getModHelpers().getMinecraftHelpers().isClientSide() || (clientConfig = config.getItemClientConfig()) != null) {
            // empty if block
        }
    }
}

