/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.ConfigurableTypesNeoForge;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

public abstract class FluidConfigNeoForge
extends ExtendedConfigCommon<FluidConfigNeoForge, BaseFlowingFluid.Properties, ModBaseNeoForge<?>> {
    public FluidConfigNeoForge(ModBaseNeoForge<?> mod, String namedId, Function<FluidConfigNeoForge, BaseFlowingFluid.Properties> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    protected static BaseFlowingFluid.Properties getDefaultFluidProperties(final ModBaseNeoForge<?> mod, final String texturePrefixPath, Consumer<FluidType.Properties> fluidAttributesConsumer) {
        FluidType.Properties fluidAttributes = FluidType.Properties.create();
        fluidAttributesConsumer.accept(fluidAttributes);
        FluidType fluidType = new FluidType(fluidAttributes);
        mod.getModEventBus().addListener(event -> event.registerFluidType(new IClientFluidTypeExtensions(){
            private final ResourceLocation STILL;
            private final ResourceLocation FLOW;
            {
                this.STILL = ResourceLocation.fromNamespaceAndPath((String)mod.getModId(), (String)(texturePrefixPath + "_still"));
                this.FLOW = ResourceLocation.fromNamespaceAndPath((String)mod.getModId(), (String)(texturePrefixPath + "_flow"));
            }

            public ResourceLocation getStillTexture() {
                return this.STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return this.FLOW;
            }
        }, new FluidType[]{fluidType}));
        Wrapper<BaseFlowingFluid.Properties> properties = new Wrapper<BaseFlowingFluid.Properties>();
        Wrapper source = new Wrapper();
        Wrapper flowing = new Wrapper();
        properties.set(new BaseFlowingFluid.Properties(() -> fluidType, () -> {
            if (source.get() == null) {
                source.set(new BaseFlowingFluid.Source((BaseFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)source.get();
        }, () -> {
            if (flowing.get() == null) {
                flowing.set(new BaseFlowingFluid.Flowing((BaseFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)flowing.get();
        }));
        return (BaseFlowingFluid.Properties)properties.get();
    }

    @Override
    public String getTranslationKey() {
        return "block." + ((ModBaseNeoForge)this.getMod()).getModId() + ".block_" + this.getNamedId();
    }

    @Override
    public ConfigurableTypeCommon getConfigurableType() {
        return ConfigurableTypesNeoForge.FLUID;
    }

    public ResourceLocation getIconLocationStill() {
        return ResourceLocation.fromNamespaceAndPath((String)((ModBaseNeoForge)this.getMod()).getModId(), (String)("blocks/" + this.getNamedId() + "_still"));
    }

    public ResourceLocation getIconLocationFlow() {
        return ResourceLocation.fromNamespaceAndPath((String)((ModBaseNeoForge)this.getMod()).getModId(), (String)("blocks/" + this.getNamedId() + "_flow"));
    }
}

