/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.DetectedVersion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.helper.DummyPathElement;
import org.cyclops.cyclopscore.helper.IMinecraftHelpers;
import org.slf4j.Logger;

public abstract class MinecraftHelpersCommon
implements IMinecraftHelpers {
    static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public int getDayLength() {
        return 24000;
    }

    @Override
    public int getComparatorMultiplier() {
        return 15;
    }

    @Override
    public int getSecondInTicks() {
        return 20;
    }

    @Override
    public int getBlockNotify() {
        return 1;
    }

    @Override
    public int getBlockNotifyClient() {
        return 2;
    }

    @Override
    public int getBlockNotifyNoRerender() {
        return 4;
    }

    @Override
    public void setDay(ServerLevel world, boolean toDay) {
        int currentTime = (int)world.getGameTime();
        int newTime = currentTime - currentTime % (this.getDayLength() / 2) + this.getDayLength() / 2;
        ((ServerLevelData)world.getLevelData()).setGameTime((long)newTime);
    }

    @Override
    public boolean isPlayerInventoryFull(Player player) {
        return player.getInventory().getFreeSlot() == -1;
    }

    @Override
    public String getMinecraftVersion() {
        return DetectedVersion.BUILT_IN.name();
    }

    @Override
    public String getMinecraftVersionMajorMinor() {
        return String.join((CharSequence)".", Arrays.asList(this.getMinecraftVersion().split("\\.")).subList(0, 2));
    }

    @Override
    public int compareBlockPos(BlockPos pos1, BlockPos pos2) {
        int compX = Integer.compare(pos1.getX(), pos2.getX());
        if (compX == 0) {
            int compY = Integer.compare(pos1.getY(), pos2.getY());
            if (compY == 0) {
                return Integer.compare(pos1.getZ(), pos2.getZ());
            }
            return compY;
        }
        return compX;
    }

    @Override
    public ItemStack getRecipeOutput(RecipeHolder<?> recipe, Level level) {
        return this.getRecipeOutput(recipe.value(), level);
    }

    @Override
    public ItemStack getRecipeOutput(Recipe<?> recipe, Level level) {
        List displays = recipe.display();
        if (displays.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((RecipeDisplay)displays.getFirst()).result().resolveForFirstStack(SlotDisplayContext.fromLevel((Level)level));
    }

    @Override
    public CompoundTag valueOutputToNbt(Consumer<ValueOutput> valueOutputConsumer, @Nullable HolderLookup.Provider lookupProvider) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new DummyPathElement(), LOGGER);){
            TagValueOutput valueOutput = lookupProvider == null ? TagValueOutput.createWithoutContext((ProblemReporter)scopedCollector) : TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider);
            valueOutputConsumer.accept((ValueOutput)valueOutput);
            CompoundTag compoundTag = valueOutput.buildResult();
            return compoundTag;
        }
    }

    @Override
    public <T> T valueInputFromNbt(CompoundTag tag, HolderLookup.Provider lookupProvider, Function<ValueInput, T> valueInputConsumer) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new DummyPathElement(), LOGGER);){
            ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider, (CompoundTag)tag);
            T t = valueInputConsumer.apply(input);
            return t;
        }
    }
}

