/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementCollectButton;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementButton;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewardsAppendixClient;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

public class AdvancementRewardsAppendix
extends SectionAppendix<AdvancementRewardsAppendixClient> {
    public static final int SLOT_SIZE = 16;
    public static final int SLOT_PADDING = 2;
    public static final int MAX_WIDTH = 80;
    public static final long ADVANCEMENT_INFO_REQUEST_TIMEOUT = 60L;
    public static final AdvancedButtonEnum COLLECT = AdvancedButtonEnum.create();
    private final AdvancedButtonEnum[] rewards;
    private final AdvancedButtonEnum[] advancements;
    private final Point[] rewardPositions;
    private final AdvancementRewards advancementRewards;
    private final int height;
    private final boolean enableRewards;
    public boolean errored = false;
    public long lastAdvancementInfoRequest = -1L;
    protected Map<AdvancedButtonEnum, AdvancedButton> renderButtonHolders = Maps.newHashMap();

    public AdvancementRewardsAppendix(IInfoBook infoBook, AdvancementRewards advancementRewards) throws InfoBookParser.InvalidAppendixException {
        super(infoBook);
        int i;
        this.advancementRewards = advancementRewards;
        this.rewards = new AdvancedButtonEnum[advancementRewards.getRewards().size()];
        this.advancements = new AdvancedButtonEnum[advancementRewards.getAdvancements().size()];
        this.rewardPositions = new Point[advancementRewards.getRewards().size()];
        int x = 0;
        int y = 0;
        int row_max_y = 0;
        int max_width = 0;
        int max_height = 0;
        for (i = 0; i < advancementRewards.getRewards().size(); ++i) {
            IReward reward = advancementRewards.getRewards().get(i);
            this.rewards[i] = AdvancedButtonEnum.create();
            row_max_y = Math.max(row_max_y, reward.getHeight() + 4);
            if (x + reward.getWidth() > 80) {
                y += row_max_y;
                max_width = Math.max(x, max_width);
                max_height = Math.max(row_max_y, max_height);
                x = 0;
                row_max_y = 0;
            }
            this.rewardPositions[i] = new Point(x, y);
            x += reward.getWidth();
        }
        for (i = 0; i < advancementRewards.getAdvancements().size(); ++i) {
            this.advancements[i] = AdvancedButtonEnum.create();
        }
        this.height = y + Math.max(row_max_y, max_height);
        this.enableRewards = infoBook.getMod().getReferenceValue(ModBaseNeoForge.REFKEY_INFOBOOK_REWARDS);
    }

    public AdvancedButtonEnum[] getRewards() {
        return this.rewards;
    }

    public AdvancedButtonEnum[] getAdvancements() {
        return this.advancements;
    }

    public Point[] getRewardPositions() {
        return this.rewardPositions;
    }

    public AdvancementRewards getAdvancementRewards() {
        return this.advancementRewards;
    }

    public Map<AdvancedButtonEnum, AdvancedButton> getRenderButtonHolders() {
        return this.renderButtonHolders;
    }

    @Override
    protected int getOffsetY() {
        return 0;
    }

    @Override
    protected int getWidth() {
        return 80;
    }

    @Override
    protected int getHeight() {
        return this.height + (int)Math.ceil(this.advancementRewards.getAdvancements().size() * 20 / 80 + 1) * 20 + 23;
    }

    @Override
    public AdvancementRewardsAppendixClient constructSectionAppendixClient() {
        return new AdvancementRewardsAppendixClient(this);
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderButtonHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        int i;
        this.renderButtonHolders.put(COLLECT, new AchievementCollectButton(this.advancementRewards, this.getInfoBook()));
        for (i = 0; i < this.advancementRewards.getRewards().size(); ++i) {
            this.renderButtonHolders.put(this.rewards[i], this.advancementRewards.getRewards().get(i).constructRewardClient().createButton(this.getInfoBook()));
        }
        for (i = 0; i < this.advancementRewards.getAdvancements().size(); ++i) {
            this.renderButtonHolders.put(this.advancements[i], new AdvancementButton(this.advancementRewards.getAdvancements().get(i)));
        }
        infoSection.addAdvancedButtons(this.getPage(), this.renderButtonHolders.values());
    }
}

