/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;

public abstract class SectionAppendix<C extends SectionAppendixClient<?>> {
    private final IInfoBook infoBook;
    private int page;
    private int lineStart;
    private C sectionAppendixClient;

    public SectionAppendix(IInfoBook infoBook) throws InfoBookParser.InvalidAppendixException {
        this.infoBook = infoBook;
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            this.sectionAppendixClient = this.constructSectionAppendixClient();
        }
    }

    public int getFullHeight() {
        return this.getHeight() + this.getOffsetY() * 2;
    }

    protected abstract int getOffsetY();

    protected abstract int getWidth();

    protected abstract int getHeight();

    public abstract C constructSectionAppendixClient() throws InfoBookParser.InvalidAppendixException;

    public C getSectionAppendixClient() {
        return this.sectionAppendixClient;
    }

    public abstract void preBakeElement(InfoSection var1);

    public abstract void bakeElement(InfoSection var1);

    public IInfoBook getInfoBook() {
        return this.infoBook;
    }

    public int getPage() {
        return this.page;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setLineStart(int lineStart) {
        this.lineStart = lineStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SectionAppendix)) {
            return false;
        }
        SectionAppendix other = (SectionAppendix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IInfoBook this$infoBook = this.getInfoBook();
        IInfoBook other$infoBook = other.getInfoBook();
        if (this$infoBook == null ? other$infoBook != null : !this$infoBook.equals(other$infoBook)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getLineStart() == other.getLineStart();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SectionAppendix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IInfoBook $infoBook = this.getInfoBook();
        result = result * 59 + ($infoBook == null ? 43 : $infoBook.hashCode());
        result = result * 59 + this.getPage();
        result = result * 59 + this.getLineStart();
        return result;
    }

    public String toString() {
        return "SectionAppendix(infoBook=" + String.valueOf(this.getInfoBook()) + ", page=" + this.getPage() + ", lineStart=" + this.getLineStart() + ")";
    }
}

