/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLike;

public interface IIngredientCollectionLikeMultiClassifiedTrait<T, M, I, L extends IIngredientCollectionLike<T, M, I>>
extends IIngredientCollectionLike<T, M, I> {
    @Nullable
    default public IngredientComponentCategoryType<T, M, ?> getFirstMatchingCategory(M matchCondition) {
        if (matchCondition.equals(this.getComponent().getMatcher().getAnyMatchCondition())) {
            return null;
        }
        for (IngredientComponentCategoryType categoryType : this.getComponent().getCategoryTypes()) {
            if (!this.getComponent().getMatcher().hasCondition(matchCondition, categoryType.getMatchCondition())) continue;
            return categoryType;
        }
        throw new IllegalStateException("Match condition does not match with any of the available category types, this is a coding error.");
    }

    default public L getBestClassifiedCollection(M matchCondition) {
        IngredientComponentCategoryType<T, M, ?> category = this.getFirstMatchingCategory(matchCondition);
        if (category == null) {
            return this.getFirstSingleClassified();
        }
        return (L)((IIngredientCollectionLike)this.getClassifiedCollections().get(category));
    }

    default public L getFirstSingleClassified() {
        return (L)((IIngredientCollectionLike)Iterables.getFirst(this.getClassifiedCollections().values(), null));
    }

    public void removeInstance(L var1, I var2);

    public Map<IngredientComponentCategoryType<T, M, ?>, L> getClassifiedCollections();

    public static class RemoveCallbackIterator<T, M, I, L extends IIngredientCollectionLike<T, M, I>>
    implements Iterator<I> {
        private final IIngredientCollectionLikeMultiClassifiedTrait<T, M, I, L> multiClassifiedCollection;
        private final Iterator<I> iterator;
        private final List<L> otherClassifiedCollections;
        private I lastNext;

        public RemoveCallbackIterator(IIngredientCollectionLikeMultiClassifiedTrait<T, M, I, L> multiClassifiedCollection, T instance, M matchCondition) {
            this.multiClassifiedCollection = multiClassifiedCollection;
            L classifiedCollection = this.multiClassifiedCollection.getBestClassifiedCollection(matchCondition);
            this.iterator = classifiedCollection.iterator(instance, matchCondition);
            this.otherClassifiedCollections = Lists.newArrayList(this.multiClassifiedCollection.getClassifiedCollections().values());
            this.otherClassifiedCollections.remove(classifiedCollection);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public I next() {
            this.lastNext = this.iterator.next();
            return this.lastNext;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            this.otherClassifiedCollections.forEach(c -> this.multiClassifiedCollection.removeInstance((IIngredientCollectionLike)c, this.lastNext));
        }
    }
}

