/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new IdentityHashMap();

    public static <T> NBTClassType<T> getClassType(Class<T> clazz) {
        return NBTYPES.get(clazz);
    }

    public static <T, I extends T> void writeNbt(Class<T> clazz, String name, I instance, ValueOutput tag) {
        NBTClassType<I> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found for " + String.valueOf(instance) + " of type " + String.valueOf(clazz));
        }
        serializationClass.writePersistedField(name, instance, tag);
    }

    public static <T> T readNbt(Class<T> clazz, String name, ValueInput tag) {
        NBTClassType<T> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found type " + String.valueOf(clazz));
        }
        return serializationClass.readPersistedField(name, tag);
    }

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    private static NBTClassType getTypeSilent(Class<?> type) {
        NBTClassType<?> action = NBTYPES.get(type);
        if (action == null) {
            for (Class<?> iface : type.getInterfaces()) {
                action = NBTYPES.get(iface);
                if (action == null) continue;
                return action;
            }
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                return NBTClassType.getTypeSilent(superClass);
            }
            return null;
        }
        return action;
    }

    public static NBTClassType getType(Class<?> type, Object target) {
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            return new INBTSerializable.SelfNBTClassType(type);
        }
        NBTClassType action = NBTClassType.getTypeSilent(type);
        if (action == null) {
            throw new RuntimeException("No NBT persist action found for type " + type.getName() + " or any of its parents and interfaces in class " + String.valueOf(target.getClass()) + " for target object " + String.valueOf(target) + ".");
        }
        return action;
    }

    public static void performActionForField(INBTProvider provider, Field field, Either<ValueInput, ValueOutput> tag) {
        Class<?> type = field.getType();
        String fieldName = field.getName();
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        NBTClassType.getType(type, provider).persistedFieldAction(provider, field, tag);
    }

    public void persistedFieldAction(INBTProvider provider, Field field, Either<ValueInput, ValueOutput> valueIo) {
        String name = field.getName();
        NBTPersist annotation = field.getAnnotation(NBTPersist.class);
        boolean useDefaultValue = annotation.useDefaultValue();
        Object castTile = field.getDeclaringClass().cast(provider);
        valueIo.ifRight(output -> {
            block5: {
                try {
                    field.setAccessible(true);
                    Object object = field.get(castTile);
                    if (object == null) break block5;
                    try {
                        this.writePersistedField(name, (T)object, (ValueOutput)output);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("Something went from with the field " + field.getName() + " in " + String.valueOf(castTile) + ": " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Can not write the field " + field.getName() + " in " + String.valueOf(castTile) + " since it does not exist. " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Can not write the field " + field.getName() + " in " + String.valueOf(castTile) + " since it can not be accessed. " + e.getMessage());
                }
            }
        });
        valueIo.ifLeft(input -> {
            Object object = null;
            try {
                try {
                    object = this.readPersistedField(name, (ValueInput)input);
                    field.setAccessible(true);
                    field.set(castTile, object);
                }
                catch (NoSuchElementException error) {
                    if (useDefaultValue) {
                        object = this.getDefaultValue();
                        field.setAccessible(true);
                        field.set(castTile, object);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new RuntimeException("Can not read the field " + field.getName() + " as " + String.valueOf(object) + " in " + String.valueOf(castTile) + " since it does not exist OR there is a class mismatch. " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Can not read the field " + field.getName() + " as " + String.valueOf(object) + " in " + String.valueOf(castTile) + " since it can not be accessed. " + e.getMessage());
            }
        });
    }

    public abstract void writePersistedField(String var1, T var2, ValueOutput var3);

    public abstract T readPersistedField(String var1, ValueInput var2);

    public abstract T getDefaultValue();

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            public void writePersistedField(String name, Integer object, ValueOutput tag) {
                tag.putInt(name, object.intValue());
            }

            @Override
            public Integer readPersistedField(String name, ValueInput tag) {
                return (Integer)tag.getInt(name).orElseThrow();
            }

            @Override
            public Integer getDefaultValue() {
                return 0;
            }
        });
        NBTYPES.put(Integer.TYPE, NBTYPES.get(Integer.class));
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            public void writePersistedField(String name, Float object, ValueOutput tag) {
                tag.putFloat(name, object.floatValue());
            }

            @Override
            public Float readPersistedField(String name, ValueInput tag) {
                return Float.valueOf(tag.getFloatOr(name, 0.0f));
            }

            @Override
            public Float getDefaultValue() {
                return Float.valueOf(0.0f);
            }
        });
        NBTYPES.put(Float.TYPE, NBTYPES.get(Float.class));
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            public void writePersistedField(String name, Boolean object, ValueOutput tag) {
                tag.putBoolean(name, object.booleanValue());
            }

            @Override
            public Boolean readPersistedField(String name, ValueInput tag) {
                return tag.getBooleanOr(name, false);
            }

            @Override
            public Boolean getDefaultValue() {
                return false;
            }
        });
        NBTYPES.put(Boolean.TYPE, NBTYPES.get(Boolean.class));
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            public void writePersistedField(String name, String object, ValueOutput tag) {
                if (object != null && !object.isEmpty()) {
                    tag.putString(name, object);
                }
            }

            @Override
            public String readPersistedField(String name, ValueInput tag) {
                return (String)tag.getString(name).orElseThrow();
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Direction.class, new NBTClassType<Direction>(){

            @Override
            public void writePersistedField(String name, Direction object, ValueOutput tag) {
                tag.putInt(name, object.ordinal());
            }

            @Override
            public Direction readPersistedField(String name, ValueInput tag) {
                return Direction.values()[(Integer)tag.getInt(name).orElseThrow()];
            }

            @Override
            public Direction getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Fluid.class, new NBTClassType<Fluid>(){

            @Override
            public void writePersistedField(String name, Fluid object, ValueOutput tag) {
                tag.putString(name, BuiltInRegistries.FLUID.getKey((Object)object).toString());
            }

            @Override
            public Fluid readPersistedField(String name, ValueInput tag) {
                String fluidName = (String)tag.getString(name).orElseThrow();
                return (Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.parse((String)fluidName));
            }

            @Override
            public Fluid getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Tag.class, new NBTClassType<Tag>(){

            @Override
            public void writePersistedField(String name, Tag object, ValueOutput tag) {
                tag.store(name, ExtraCodecs.NBT, (Object)object);
            }

            @Override
            public Tag readPersistedField(String name, ValueInput tag) {
                return (Tag)tag.read(name, ExtraCodecs.NBT).orElseThrow();
            }

            @Override
            public Tag getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Set.class, new CollectionNBTClassType<Set>(){

            @Override
            protected Set createNewCollection() {
                return Sets.newHashSet();
            }
        });
        NBTYPES.put(List.class, new CollectionNBTClassType<List>(){

            @Override
            protected List createNewCollection() {
                return Lists.newLinkedList();
            }
        });
        NBTYPES.put(Map.class, new NBTClassType<Map>(){

            @Override
            public void writePersistedField(String name, Map object, ValueOutput tag) {
                ValueOutput mapTag = tag.child(name);
                ValueOutput.ValueOutputList list = mapTag.childrenList("map");
                boolean setKeyType = false;
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    ValueOutput entryTag = list.addChild();
                    10.getType(entry.getKey().getClass(), object).writePersistedField("k", entry.getKey(), entryTag);
                    if (entry.getValue() != null) {
                        10.getType(entry.getValue().getClass(), object).writePersistedField("v", entry.getValue(), entryTag.child("v"));
                    }
                    if (!setKeyType) {
                        setKeyType = true;
                        mapTag.putString("keyType", entry.getKey().getClass().getName());
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.putString("valueType", entry.getValue().getClass().getName());
                }
            }

            @Override
            public Map readPersistedField(String name, ValueInput tag) {
                ValueInput mapTag = (ValueInput)tag.child(name).orElseThrow();
                HashMap map = Maps.newHashMap();
                ValueInput.ValueInputList list = (ValueInput.ValueInputList)mapTag.childrenList("map").orElseThrow();
                if (!list.isEmpty()) {
                    NBTClassType keyNBTClassType;
                    Wrapper valueNBTClassType = new Wrapper();
                    try {
                        Class<?> keyType = Class.forName((String)mapTag.getString("keyType").orElseThrow());
                        keyNBTClassType = 10.getType(keyType, map);
                    }
                    catch (ClassNotFoundException e) {
                        CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map key '" + String.valueOf(mapTag.getString("keyType")) + "', this could be a mod error.");
                        return map;
                    }
                    mapTag.getString("valueType").ifPresent(valueTypeString -> {
                        try {
                            Class<?> valueType = Class.forName(valueTypeString);
                            valueNBTClassType.set(10.getType(valueType, map));
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + String.valueOf(mapTag.getString("valueType")) + "', this could be a mod error.");
                        }
                    });
                    for (ValueInput entryTag : list) {
                        Object key = keyNBTClassType.readPersistedField("k", entryTag);
                        Object value = null;
                        Optional entryTagChild = entryTag.child("v");
                        if (valueNBTClassType != null && entryTagChild.isPresent()) {
                            value = ((NBTClassType)valueNBTClassType.get()).readPersistedField("v", (ValueInput)entryTagChild.orElseThrow());
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public Map getDefaultValue() {
                return Maps.newHashMap();
            }
        });
        NBTYPES.put(Vec3i.class, new NBTClassType<Vec3i>(){

            @Override
            public void writePersistedField(String name, Vec3i object, ValueOutput tag) {
                tag.putIntArray(name, new int[]{object.getX(), object.getY(), object.getZ()});
            }

            @Override
            public Vec3i readPersistedField(String name, ValueInput tag) {
                int[] array = (int[])tag.getIntArray(name).orElseThrow();
                return new Vec3i(array[0], array[1], array[2]);
            }

            @Override
            public Vec3i getDefaultValue() {
                return IModHelpers.get().getLocationHelpers().copyLocation(Vec3i.ZERO);
            }
        });
        NBTYPES.put(Vec3.class, new NBTClassType<Vec3>(){

            @Override
            public void writePersistedField(String name, Vec3 object, ValueOutput tag) {
                ValueOutput vec = tag.child(name);
                vec.putDouble("x", object.x);
                vec.putDouble("y", object.y);
                vec.putDouble("z", object.z);
            }

            @Override
            public Vec3 readPersistedField(String name, ValueInput tag) {
                ValueInput vec = (ValueInput)tag.child(name).orElseThrow();
                return new Vec3(vec.getDoubleOr("x", 0.0), vec.getDoubleOr("y", 0.0), vec.getDoubleOr("z", 0.0));
            }

            @Override
            public Vec3 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Pair.class, new NBTClassType<Pair>(){

            @Override
            public void writePersistedField(String name, Pair object, ValueOutput tag) {
                ValueOutput pairTag = tag.child(name);
                ValueOutput leftTag = pairTag.child("left");
                ValueOutput rightTag = pairTag.child("right");
                13.getType(object.getLeft().getClass(), object).writePersistedField("element", object.getLeft(), leftTag);
                13.getType(object.getRight().getClass(), object).writePersistedField("element", object.getRight(), rightTag);
                pairTag.putString("leftType", object.getLeft().getClass().getName());
                pairTag.putString("rightType", object.getRight().getClass().getName());
            }

            @Override
            public Pair readPersistedField(String name, ValueInput tag) {
                NBTClassType rightElementNBTClassType;
                NBTClassType leftElementNBTClassType;
                ValueInput pairTag = (ValueInput)tag.child(name).orElseThrow();
                ValueInput leftTag = (ValueInput)pairTag.child("left").orElseThrow();
                ValueInput rightTag = (ValueInput)pairTag.child("right").orElseThrow();
                try {
                    Class<?> elementType = Class.forName((String)pairTag.getString("leftType").orElseThrow());
                    leftElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair left element '" + String.valueOf(pairTag.getString("leftType")) + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                try {
                    Class<?> elementType = Class.forName((String)pairTag.getString("rightType").orElseThrow());
                    rightElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair right element '" + String.valueOf(pairTag.getString("rightType")) + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                Object left = leftElementNBTClassType.readPersistedField("element", leftTag);
                Object right = rightElementNBTClassType.readPersistedField("element", rightTag);
                return Pair.of(left, right);
            }

            @Override
            public Pair getDefaultValue() {
                return Pair.of(null, null);
            }
        });
        NBTYPES.put(ItemStack.class, new NBTClassType<ItemStack>(){

            @Override
            public void writePersistedField(String name, ItemStack object, ValueOutput tag) {
                if (object != null) {
                    tag.store(name, ItemStack.OPTIONAL_CODEC, (Object)object);
                }
            }

            @Override
            public ItemStack readPersistedField(String name, ValueInput tag) {
                return (ItemStack)tag.read(name, ItemStack.OPTIONAL_CODEC).orElseThrow();
            }

            @Override
            public ItemStack getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Component.class, new NBTClassType<Component>(){

            @Override
            public void writePersistedField(String name, Component object, ValueOutput tag) {
                if (object != null) {
                    tag.store(name, ComponentSerialization.CODEC, (Object)object);
                }
            }

            @Override
            public Component readPersistedField(String name, ValueInput tag) {
                return (Component)tag.read(name, ComponentSerialization.CODEC).orElseThrow();
            }

            @Override
            public Component getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(EnumFacingMap.class, new NBTClassType<EnumFacingMap>(){

            @Override
            public void writePersistedField(String name, EnumFacingMap object, ValueOutput tag) {
                ValueOutput mapTag = tag.child(name);
                ValueOutput.ValueOutputList list = mapTag.childrenList("map");
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    ValueOutput entryTag = list.addChild();
                    entryTag.putInt("k", ((Direction)entry.getKey()).ordinal());
                    if (entry.getValue() != null) {
                        16.getType(entry.getValue().getClass(), object).writePersistedField("v", entry.getValue(), entryTag.child("v"));
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.putString("valueType", entry.getValue().getClass().getName());
                }
            }

            @Override
            public EnumFacingMap readPersistedField(String name, ValueInput tag) {
                ValueInput mapTag = (ValueInput)tag.child(name).orElseThrow();
                EnumFacingMap<Object> map = EnumFacingMap.newMap();
                ValueInput.ValueInputList list = (ValueInput.ValueInputList)mapTag.childrenList("map").orElseThrow();
                if (!list.isEmpty()) {
                    Wrapper valueNBTClassType = new Wrapper();
                    mapTag.getString("valueType").ifPresent(valueTypeString -> {
                        try {
                            Class<?> valueType = Class.forName(valueTypeString);
                            valueNBTClassType.set(16.getType(valueType, map));
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + String.valueOf(mapTag.getString("valueType")) + "', this could be a mod error.");
                        }
                    });
                    for (ValueInput entryTag : list) {
                        Direction key = Direction.values()[(Integer)entryTag.getInt("k").orElseThrow()];
                        Object value = null;
                        Optional entryTagChild = entryTag.child("v");
                        if (valueNBTClassType != null && entryTagChild.isPresent()) {
                            value = ((NBTClassType)valueNBTClassType.get()).readPersistedField("v", (ValueInput)entryTagChild.orElseThrow());
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public EnumFacingMap getDefaultValue() {
                return EnumFacingMap.newMap();
            }
        });
    }

    private static abstract class CollectionNBTClassType<C extends Collection>
    extends NBTClassType<C> {
        private CollectionNBTClassType() {
        }

        protected abstract C createNewCollection();

        @Override
        public C getDefaultValue() {
            return this.createNewCollection();
        }

        @Override
        public void writePersistedField(String name, C object, ValueOutput tag) {
            ValueOutput collectionTag = tag.child(name);
            ValueOutput.ValueOutputList list = collectionTag.childrenList("collection");
            boolean setTypes = false;
            for (Object element : object) {
                ValueOutput elementTag = list.addChild();
                CollectionNBTClassType.getType(element.getClass(), object).writePersistedField("element", element, elementTag);
                if (setTypes) continue;
                setTypes = true;
                collectionTag.putString("elementType", element.getClass().getName());
            }
        }

        @Override
        public C readPersistedField(String name, ValueInput tag) {
            ValueInput collectionTag = (ValueInput)tag.child(name).orElseThrow();
            C collection = this.createNewCollection();
            ValueInput.ValueInputList list = (ValueInput.ValueInputList)collectionTag.childrenList("collection").orElseThrow();
            if (!list.isEmpty()) {
                NBTClassType elementNBTClassType;
                try {
                    Class<?> elementType = Class.forName((String)collectionTag.getString("elementType").orElseThrow());
                    elementNBTClassType = CollectionNBTClassType.getType(elementType, collection);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type collection element '" + String.valueOf(collectionTag.getString("elementType")) + "', this could be a mod error.");
                    return collection;
                }
                for (ValueInput entryTag : list) {
                    collection.add(elementNBTClassType.readPersistedField("element", entryTag));
                }
            }
            return collection;
        }
    }
}

