/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemStackFromIngredient {
    private final List<String> modPriorities;
    private final TagKey<Item> tag;
    private final int count;
    @Nullable
    private Ingredient ingredient;
    @Nullable
    private ItemStack firstItemStack;

    public ItemStackFromIngredient(List<String> modPriorities, TagKey<Item> tag, int count) {
        this.modPriorities = modPriorities;
        this.tag = tag;
        this.count = count;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public Ingredient getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(this.tag));
        }
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getFirstItemStack() {
        if (this.firstItemStack != null) {
            return this.firstItemStack;
        }
        HolderSet matchingItems = this.getIngredient().getValues();
        HashMap modPriorityIndex = Maps.newHashMap();
        for (int i = 0; i < this.modPriorities.size(); ++i) {
            modPriorityIndex.put(this.modPriorities.get(i), i);
        }
        ItemStack outputStack = matchingItems.stream().map(ItemStack::new).min(Comparator.comparingInt(e -> modPriorityIndex.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)e.getItem()).getNamespace(), Integer.MAX_VALUE))).orElseThrow(() -> new IllegalStateException("No tag value found for " + String.valueOf(this.tag))).copy();
        this.firstItemStack = outputStack.copy();
        this.firstItemStack.setCount(this.count);
        return this.firstItemStack;
    }

    public void writeToPacket(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.modPriorities.size());
        for (String modPriority : this.modPriorities) {
            buf.writeUtf(modPriority);
        }
        TagKey.streamCodec((ResourceKey)Registries.ITEM).encode((Object)buf, this.tag);
        buf.writeVarInt(this.count);
    }

    public static ItemStackFromIngredient readFromPacket(RegistryFriendlyByteBuf buf) {
        ArrayList modPriorities = Lists.newArrayList();
        int modPrioritiesSize = buf.readVarInt();
        for (int i = 0; i < modPrioritiesSize; ++i) {
            modPriorities.add(buf.readUtf());
        }
        TagKey tag = (TagKey)TagKey.streamCodec((ResourceKey)Registries.ITEM).decode((Object)buf);
        int count = buf.readVarInt();
        return new ItemStackFromIngredient(modPriorities, (TagKey<Item>)tag, count);
    }
}

