/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class EntityRenderTypeHelper {
    private static final Map<String, Function<ResourceLocation, RenderType>> RENDER_TYPES_BY_NAME;
    private static final Map<String, BiFunction<ResourceLocation, Boolean, RenderType>> VAR_OUTLINE_RENDER_TYPES_BY_NAME;

    public static RenderType getRenderTypeWithTexture(RenderType renderType, ResourceLocation texture) {
        Function<ResourceLocation, RenderType> supplier;
        if (renderType instanceof RenderType.CompositeRenderType && (supplier = VAR_OUTLINE_RENDER_TYPES_BY_NAME.get(renderType.name)) != null) {
            RenderType.OutlineProperty outlineProperty = ((RenderType.CompositeRenderType)renderType).state.outlineProperty;
            return (RenderType)supplier.apply(texture, outlineProperty == RenderType.OutlineProperty.AFFECTS_OUTLINE);
        }
        supplier = RENDER_TYPES_BY_NAME.get(renderType.name);
        if (supplier != null) {
            return (RenderType)supplier.apply(texture);
        }
        return null;
    }

    static {
        ImmutableMap.Builder renderTypes = ImmutableMap.builder();
        renderTypes.put((Object)"armor_cutout_no_cull", RenderType::armorCutoutNoCull);
        renderTypes.put((Object)"entity_solid", RenderType::entitySolid);
        renderTypes.put((Object)"entity_cutout", RenderType::entityCutout);
        renderTypes.put((Object)"item_entity_translucent_cull", RenderType::itemEntityTranslucentCull);
        renderTypes.put((Object)"entity_translucent", RenderType::entityTranslucent);
        renderTypes.put((Object)"entity_smooth_cutout", RenderType::entitySmoothCutout);
        renderTypes.put((Object)"entity_decal", RenderType::entityDecal);
        renderTypes.put((Object)"entity_no_outline", RenderType::entityNoOutline);
        renderTypes.put((Object)"entity_alpha", RenderType::dragonExplosionAlpha);
        renderTypes.put((Object)"eyes", RenderType::eyes);
        renderTypes.put((Object)"water_mask", t -> RenderType.waterMask());
        renderTypes.put((Object)"armor_entity_glint", t -> RenderType.armorEntityGlint());
        RENDER_TYPES_BY_NAME = renderTypes.build();
        ImmutableMap.Builder outlineRenderTypes = ImmutableMap.builder();
        outlineRenderTypes.put((Object)"entity_cutout_no_cull", RenderType::entityCutoutNoCull);
        outlineRenderTypes.put((Object)"entity_cutout_no_cull_z_offset", RenderType::entityCutoutNoCullZOffset);
        outlineRenderTypes.put((Object)"entity_translucent", RenderType::entityTranslucent);
        outlineRenderTypes.put((Object)"entity_translucent_emissive", RenderType::entityTranslucentEmissive);
        VAR_OUTLINE_RENDER_TYPES_BY_NAME = outlineRenderTypes.build();
    }
}

