/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.util.Mth;

public class ConnectingTextureType
implements TextureType<ConnectingTextureData> {
    @Override
    public ConnectingTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        ConnectingTextureData.Builder builder = ConnectingTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        if (json.has("layout")) {
            ConnectingTextureLayout layout;
            if (!json.get("layout").isJsonPrimitive() || !json.getAsJsonPrimitive("layout").isString()) {
                throw new JsonParseException("Property 'layout' must be a string!");
            }
            String layoutString = json.get("layout").getAsString();
            try {
                layout = ConnectingTextureLayout.valueOf(layoutString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'layout' must be one of " + Arrays.toString((Object[])ConnectingTextureLayout.values()).toLowerCase(Locale.ROOT) + ", not '" + layoutString + "'!");
            }
            builder.layout(layout);
        }
        return (ConnectingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ConnectingTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getLayout() != ConnectingTextureLayout.FULL) {
            json.addProperty("layout", data.getLayout().name().toLowerCase(Locale.ROOT));
        }
        return json.isEmpty() ? null : json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ConnectingTextureData data) {
        if (data.getLayout() == ConnectingTextureLayout.FULL && context.getTextureWidth() == context.getTextureHeight()) {
            return Pair.of(context.getTextureWidth(), context.getTextureHeight() * 6 / 8);
        }
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            AnimationMetadataSection animation = context.getAnimationMetadata();
            if (animation.frameWidth().isPresent() && animation.frameHeight().isPresent()) {
                frameSize = Pair.of((Integer)animation.frameWidth().get(), (Integer)animation.frameHeight().get());
            } else if (animation.frameWidth().isPresent()) {
                frameSize = Pair.of((Integer)animation.frameWidth().get(), context.getTextureHeight());
            } else if (animation.frameHeight().isPresent()) {
                frameSize = Pair.of(context.getTextureWidth(), (Integer)animation.frameHeight().get());
            } else {
                ConnectingTextureLayoutHandler handler = ConnectingTextureLayoutHandler.get(data.getLayout());
                int height = Math.min(context.getTextureWidth() / handler.getWidth() * handler.getHeight(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!Mth.isMultipleOf((int)context.getTextureWidth(), (int)frameSize.left()) || !Mth.isMultipleOf((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + String.valueOf(frameSize.left()) + "x" + String.valueOf(frameSize.right()) + "!");
            }
            return frameSize;
        }
        return Pair.of(context.getTextureWidth(), context.getTextureHeight());
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, ConnectingTextureData data) {
        ConnectingTextureLayoutHandler layoutHandler = ConnectingTextureLayoutHandler.get(data.getLayout());
        TextureAtlasSprite sprite = context.createOriginalSprite();
        float startU = sprite.u0;
        float startV = sprite.v0;
        float tileWidth = (sprite.u1 - sprite.u0) / (float)layoutHandler.getWidth();
        float tileHeight = (sprite.v1 - sprite.v0) / (float)layoutHandler.getHeight();
        sprite.u1 = sprite.u0 + tileWidth * (float)(layoutHandler.defaultTileX() + 1);
        sprite.v1 = sprite.v0 + tileHeight * (float)(layoutHandler.defaultTileY() + 1);
        sprite.u0 += tileWidth * (float)layoutHandler.defaultTileX();
        sprite.v0 += tileHeight * (float)layoutHandler.defaultTileY();
        return new ConnectingTextureSprite(sprite, data, startU, startV);
    }
}

