/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v3;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import dev.isxander.yacl3.config.v3.AbstractReadonlyConfigEntry;
import dev.isxander.yacl3.config.v3.CodecConfig;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ChildConfigEntryImpl<T extends CodecConfig<T>>
extends AbstractReadonlyConfigEntry<T> {
    private final T config;
    private final MapCodec<T> mapCodec;

    public ChildConfigEntryImpl(String fieldName, T config) {
        super(fieldName);
        this.config = config;
        this.mapCodec = config.fieldOf(this.fieldName());
    }

    @Override
    protected T innerGet() {
        return this.config;
    }

    @Override
    public <R> RecordBuilder<R> encode(DynamicOps<R> ops, RecordBuilder<R> recordBuilder) {
        return this.mapCodec.encode(this.config, ops, recordBuilder);
    }

    @Override
    public <R> boolean decode(R encoded, DynamicOps<R> ops) {
        DataResult result = this.mapCodec.decoder().parse(ops, encoded);
        Optional error = result.error();
        if (error.isPresent()) {
            YACLConstants.LOGGER.error("Failed to decode entry {}: {}", (Object)this.fieldName(), (Object)((DataResult.Error)error.get()).message());
            return false;
        }
        return true;
    }
}

