/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import dev.isxander.yacl3.gui.render.GuiRenderStateSink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public record BaseRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f pose, @Nullable ScreenRectangle bounds, @Nullable ScreenRectangle scissorArea) {
    public static BaseRenderState create(GuiGraphics graphics, @Nullable ResourceLocation texture, int x0, int y0, int x1, int y1) {
        @Nullable ScreenRectangle scissorArea = GuiRenderStateSink.peekScissorStack(graphics);
        ScreenRectangle bounds = BaseRenderState.boundsFromMaxPoints(x0, y0, x1, y1, (Matrix3x2f)graphics.pose(), scissorArea);
        return new BaseRenderState(texture != null ? RenderPipelines.GUI_TEXTURED : RenderPipelines.GUI, BaseRenderState.textureSetup(texture), new Matrix3x2f((Matrix3x2fc)graphics.pose()), bounds, scissorArea);
    }

    public static BaseRenderState create(GuiGraphics graphics, @Nullable ResourceLocation texture) {
        return new BaseRenderState(texture != null ? RenderPipelines.GUI_TEXTURED : RenderPipelines.GUI, BaseRenderState.textureSetup(texture), new Matrix3x2f((Matrix3x2fc)graphics.pose()), null, GuiRenderStateSink.peekScissorStack(graphics));
    }

    private static TextureSetup textureSetup(@Nullable ResourceLocation texture) {
        return texture == null ? TextureSetup.noTexture() : TextureSetup.singleTexture((GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(texture).getTextureView());
    }

    private static ScreenRectangle boundsFromMaxPoints(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable ScreenRectangle scissorArea) {
        ScreenRectangle bounds = new ScreenRectangle(x0, y0, x1 - x0, y1 - y0).transformMaxBounds(pose);
        return scissorArea != null ? scissorArea.intersection(bounds) : bounds;
    }
}

