/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.BlockHorizontalWaterLogged;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTriggers;

public class BlockAbandonedGrave
extends BlockHorizontalWaterLogged {
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.create((String)"model_texture", (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    public static final MapCodec<BlockAbandonedGrave> CODEC = MapCodec.unit(BlockAbandonedGrave::new);
    private static final EnumMap<Direction, VoxelShape> COLLISIONS = new EnumMap(Direction.class);

    public BlockAbandonedGrave() {
        super(BlockAbandonedGrave.getBuilder().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"abandoned_grave"))));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<BlockAbandonedGrave> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MODEL_TEXTURE});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!EntityHelper.isValidPlayer(player)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            boolean usedFlute;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LootParams lootParams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withLuck(serverPlayer.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).create(LootContextParamSets.GIFT);
            ObjectArrayList stacks = LootHelper.getLootTable(UpdaterHandler.PoolType.ABANDONED_GRAVE).getRandomItems(lootParams);
            for (ItemStack stack : stacks) {
                ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)stack);
            }
            TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 5);
            boolean bl = usedFlute = EntityHelper.getStat(serverPlayer, Stats.ITEM_USED.get((Object)ModItems.ritual_flute)) > 0;
            if (usedFlute) {
                if (state.getFluidState().is(FluidTags.WATER)) {
                    if (EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT) < 1) {
                        LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 1);
                    }
                } else if (EntityHelper.getCustomStat(serverPlayer, ModStats.ERDOS_FRAGMENTS) < 1) {
                    LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.ERDOS_FRAGMENTS, 1);
                }
            } else if (Helper.RANDOM.nextInt(100) < 10) {
                ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)new ItemStack((ItemLike)ModItems.ritual_flute));
            }
            level.playSound(null, pos, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.BLOCKS, 0.5f, 1.0f);
            ModTriggers.tomb_raiding.trigger(serverPlayer);
            LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage(serverPlayer, new Object[0]);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return COLLISIONS.computeIfAbsent((Direction)state.getValue((Property)FACING), direction -> Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.3125, (double)0.125, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), Shapes.box((double)0.4025, (double)0.375, (double)0.4025, (double)0.59375, (double)0.53125, (double)0.59375), Helper.createShapeForDirection(direction, 0.28125, 0.53125, 0.4375, 0.71875, 0.96875, 0.5625)}));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return false;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return 0.0f;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility toolAction, boolean simulate) {
        return null;
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(20.0f, 1.8E7f).sound(SoundType.STONE).pushReaction(PushReaction.IGNORE).emissiveRendering((state, level, pos) -> true).lightLevel(state -> 5);
    }
}

