/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessagePlayerCapSetWatcherKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTriggers;

public final class BlockDecorativeGrave
extends BlockGraveBase
implements EntityBlock {
    public static final MapCodec<BlockDecorativeGrave> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.INT.fieldOf("grave_model").forGetter(a -> a.graveModel.ordinal())).apply((Applicative)c, modelId -> new BlockDecorativeGrave(GraveModel.byId(modelId))));
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.create((String)"is_engraved");
    public static final EnumProperty<SoulType> SOUL_TYPE = EnumProperty.create((String)"soul_type", SoulType.class);

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)("decorative_" + graveModel.getSerializedName())))), graveModel);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(false))).setValue(SOUL_TYPE, (Comparable)((Object)SoulType.NONE)));
    }

    protected MapCodec<BlockDecorativeGrave> codec() {
        return CODEC;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        assert (state != null);
        return (BlockState)((BlockState)state.setValue((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(ItemBlockGrave.getModelTexture(context.getItemInHand())))).setValue((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(EngravableHelper.isEngraved(context.getItemInHand())));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IS_ENGRAVED, SOUL_TYPE});
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (!EntityHelper.isValidPlayer(playerIn) || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        ISoulConsumer soulConsumer = null;
        ItemStack validStack = ItemStack.EMPTY;
        boolean isSoulReceptacle = playerIn.getMainHandItem().is((Item)ModItems.receptacle_of_soul);
        boolean isNetherStar = playerIn.getMainHandItem().is(Tags.Items.NETHER_STARS);
        if (isSoulReceptacle || isNetherStar) {
            validStack = playerIn.getMainHandItem();
        } else {
            ISoulConsumer offhandSoulConsumer;
            Item item;
            if (!playerIn.getOffhandItem().isEmpty() && (item = playerIn.getOffhandItem().getItem()) instanceof ISoulConsumer && (offhandSoulConsumer = (ISoulConsumer)item).isUsingOffhandToEnchant()) {
                soulConsumer = offhandSoulConsumer;
                validStack = playerIn.getOffhandItem();
            }
            if (validStack.isEmpty() && !playerIn.getMainHandItem().isEmpty() && (item = playerIn.getMainHandItem().getItem()) instanceof ISoulConsumer) {
                ISoulConsumer mainhandSoulConsumer = (ISoulConsumer)item;
                if (mainhandSoulConsumer.isUsingOffhandToEnchant()) {
                    if (!playerIn.level().isClientSide()) {
                        LangKey.MESSAGE_ENCHANT_WITH_OFFHAND.sendMessage((ServerPlayer)playerIn, new Object[0]);
                    }
                    return InteractionResult.FAIL;
                }
                soulConsumer = mainhandSoulConsumer;
                validStack = playerIn.getMainHandItem();
            }
        }
        if (validStack.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (playerIn.level().isClientSide()) {
            return EntityHelper.noGlobalItemCooldown(playerIn, validStack) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave(level, pos);
        if (blockEntity.map(be -> be.applyScreaming(serverPlayer)).orElse(false).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (!isSoulReceptacle && !isNetherStar && soulConsumer == null) {
            return InteractionResult.PASS;
        }
        if (EntityHelper.noGlobalItemCooldown((Player)serverPlayer, validStack)) {
            if (isNetherStar) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
                int elyraDiaryCount = EntityHelper.getCustomStat(serverPlayer, ModStats.ELYRA_DIARY);
                if (elyraDiaryCount < 4) {
                    LangKey.MESSAGE_WATCHER_KNOWLEDGE_1_FIND_ELYRA_DIARY.sendMessage(serverPlayer, new Object[0]);
                    return InteractionResult.FAIL;
                }
                SoulType soulType = (SoulType)((Object)state.getValue(SOUL_TYPE));
                if (soulType == SoulType.STRONG) {
                    if (TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)serverPlayer, 1)) {
                        LangKey.MESSAGE_WATCHER_KNOWLEDGE_1_ALREADY_UNLOCKED.sendMessage(serverPlayer, new Object[0]);
                        return InteractionResult.FAIL;
                    }
                    TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 10);
                    TBPlayerCapabilityHandler.unlockWatcherKnowledge(playerIn, 1);
                    PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(TBPlayerCapabilityHandler.getWatcherKnowledge((Player)serverPlayer)), serverPlayer);
                    stack.shrink(1);
                    LangKey.MESSAGE_WATCHER_KNOWLEDGE_1_UNLOCKED.sendMessage(serverPlayer, new Object[0]);
                    level.setBlock(pos, (BlockState)state.setValue(SOUL_TYPE, (Comparable)((Object)soulType.consume(2))), 3);
                    blockEntity.ifPresent(BlockEntityDecorativeGrave::resetCheckSoul);
                    level.playSound(null, pos, ModSounds.magic_use01, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (soulType == SoulType.NONE) {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage(serverPlayer, new Object[0]);
                } else {
                    LangKey.MESSAGE_REQUIRE_BLUE_SOUL.sendMessage(serverPlayer, new Object[0]);
                }
            }
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, validStack, 10);
                if (((SoulType)((Object)state.getValue(SOUL_TYPE))).hasSoul()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendMessage(serverPlayer, new Object[0]);
                    return InteractionResult.FAIL;
                }
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.TRIGGERED);
                if (bolt != null) {
                    bolt.snapTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    bolt.setVisualOnly(true);
                    level.addFreshEntity((Entity)bolt);
                }
                level.setBlock(pos, (BlockState)state.setValue(SOUL_TYPE, (Comparable)((Object)SoulType.WEAK)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendSpecialMessage(serverPlayer, new Object[0]);
                if (!serverPlayer.isCreative()) {
                    serverPlayer.getMainHandItem().shrink(1);
                }
                TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 10);
                TBPlayerCapabilityHandler.rewardAlignment(serverPlayer, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get());
                ModTriggers.free_soul.trigger(serverPlayer);
                return InteractionResult.SUCCESS;
            }
            if (soulConsumer.isEnchanted(validStack)) {
                LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage(serverPlayer, new Object[0]);
            } else {
                SoulType soulType = (SoulType)((Object)state.getValue(SOUL_TYPE));
                if (soulType.hasSoul()) {
                    int soulStrength = soulType.getSoulStrength();
                    if (soulConsumer.canEnchant(level, pos, (Player)serverPlayer, validStack)) {
                        ISoulConsumer.ConsumeResult consumeResult = soulConsumer.setEnchant(level, pos, serverPlayer, validStack, soulStrength);
                        if (consumeResult.result().success()) {
                            int corruptionLevel;
                            if (soulStrength == 2) {
                                if (consumeResult.soulStrength() == 1) {
                                    blockEntity.ifPresent(te -> te.increaseCorruption(25));
                                    ModTriggers.knowledge_wasted.trigger(serverPlayer);
                                } else if (consumeResult.soulStrength() > 1) {
                                    ModTriggers.create_ancient_item.trigger(serverPlayer);
                                }
                            }
                            level.setBlock(pos, (BlockState)state.setValue(SOUL_TYPE, (Comparable)((Object)soulType.consume(consumeResult.soulStrength()))), 3);
                            blockEntity.ifPresent(BlockEntityDecorativeGrave::resetCheckSoul);
                            level.playSound(null, pos, ModSounds.magic_use01, SoundSource.BLOCKS, 0.5f, 1.0f);
                            LangKey.sendSystemMessage(serverPlayer, consumeResult.message(), StyleType.MESSAGE_SPECIAL);
                            ModTriggers.consume_soul.trigger(serverPlayer);
                            TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, soulConsumer.getKnowledge());
                            if (blockEntity.isPresent() && (corruptionLevel = soulConsumer.getCorruptionLevel(stack)) > 0) {
                                blockEntity.get().increaseCorruption(corruptionLevel);
                            }
                        } else {
                            LangKey.sendSystemMessage(serverPlayer, consumeResult.message(), StyleType.COLOR_RED);
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage(serverPlayer, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage(serverPlayer, new Object[0]);
                }
            }
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, validStack, 10);
        }
        return InteractionResult.SUCCESS;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier insideBlockEffectApplier) {
        ISoulConsumer soulConsumer;
        ServerPlayer serverPlayer;
        ItemStack stack;
        Item item;
        if (entity.isShiftKeyDown() && entity.isAlive() && TimeHelper.atInterval(entity, 40) && EntityHelper.isValidServerPlayer(entity) && !level.isClientSide() && (!((item = (stack = (serverPlayer = (ServerPlayer)entity).getMainHandItem()).getItem()) instanceof ISoulConsumer) || !(soulConsumer = (ISoulConsumer)item).onSneakGrave((ServerLevel)level, pos, serverPlayer, stack))) {
            if (stack.is((Item)ModItems.grave_dust) && EntityHelper.noGlobalItemCooldown((Player)serverPlayer, stack)) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
                int riteOfSilentBondCount = EntityHelper.getCustomStat(serverPlayer, ModStats.RITE_OF_SILENT_BOND);
                if (riteOfSilentBondCount < 4) {
                    LangKey.MESSAGE_WATCHER_KNOWLEDGE_0_FIND_RITE_OF_SILENT_BOND.sendMessage(serverPlayer, new Object[0]);
                    return;
                }
                Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave(level, pos);
                if (blockEntity.map(be -> be.applyScreaming(serverPlayer)).orElse(false).booleanValue()) {
                    return;
                }
                if (!TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)serverPlayer, 0)) {
                    TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 10);
                    TBPlayerCapabilityHandler.unlockWatcherKnowledge((Player)serverPlayer, 0);
                    PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(TBPlayerCapabilityHandler.getWatcherKnowledge((Player)serverPlayer)), serverPlayer);
                    LangKey.MESSAGE_WATCHER_KNOWLEDGE_0_UNLOCKED.sendMessage(serverPlayer, new Object[0]);
                }
                stack.shrink(1);
                EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.beyond_the_grave_bond, TimeHelper.tickFromMinute(15));
                MutableComponent effectName = ((MobEffect)ModEffects.beyond_the_grave_bond.value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
                blockEntity.ifPresent(BlockEntityDecorativeGrave::applySpammingRite);
            } else if (TimeHelper.isDateAroundSpringBloom()) {
                BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
                boolean valid = false;
                for (int x = -2; x <= 2; ++x) {
                    block1: for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            currentPos.set(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
                            if (!level.getBlockState((BlockPos)currentPos).is(ModBlocks.thornveil)) continue;
                            valid = true;
                            continue block1;
                        }
                    }
                }
                if (valid) {
                    ServerPlayer player = (ServerPlayer)entity;
                    EffectHelper.addEffect((LivingEntity)player, ModEffects.earthly_garden, TimeHelper.tickFromMinute(15));
                    MutableComponent effectName = ((MobEffect)ModEffects.earthly_garden.value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
                    LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
                    ModTriggers.kneel_thornveil_grave.trigger(player);
                }
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide()) {
            String engraved_name;
            int corruption = (Integer)stack.getOrDefault(ModDataComponents.CORRUPTION_LEVEL, (Object)0);
            if (corruption > 0) {
                Helper.getDecorativeGrave(level, pos).ifPresent(te -> te.increaseCorruption(corruption));
            }
            if (!(engraved_name = EngravableHelper.getEngravedName(stack)).isEmpty()) {
                Helper.getDecorativeGrave(level, pos).ifPresent(tile -> tile.setOwner(Optional.ofNullable(placer).filter(Player.class::isInstance).map(Player.class::cast).map(p -> p.getGameProfile().getId()).orElse(null), engraved_name, TimeHelper.systemTime()));
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player) ? super.getDestroyProgress(state, player, blockGetter, pos) : 0.0f;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest && Helper.getDecorativeGrave(level, pos).map(g -> g.isOwner(player)).orElse(false).booleanValue()) {
            level.levelEvent((Entity)player, 2001, pos, BlockDecorativeGrave.getId((BlockState)state));
            if (!level.isClientSide()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public void onDrop(Level level, BlockPos pos, BlockState oldState) {
        Helper.getDecorativeGrave(level, pos).ifPresent(grave -> {
            ItemStack stack = ItemBlockGrave.createDecorativeStack(this.graveModel, (Integer)oldState.getValue((Property)MODEL_TEXTURE), grave.getOwnerName());
            stack.set(ModDataComponents.CORRUPTION_LEVEL, (Object)grave.getCorruptionLevel());
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        });
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDecorativeGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockDecorativeGrave.createTickerHelper(entityType, ModBlocks.tile_decorative_grave, level.isClientSide() ? BlockEntityDecorativeGrave::clientTick : BlockEntityDecorativeGrave::serverTick);
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(20.0f, 1.8E7f).sound(SoundType.STONE);
    }
}

