/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import ovh.corail.tombstone.registry.ModBlocks;

public final class BlockGraveMarble
extends Block {
    public final String name;

    public BlockGraveMarble(MarbleType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.name = type.getSerializedName() + "_marble";
    }

    public static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(4.0f, 1.8E7f).lightLevel(s -> 0).sound(SoundType.STONE);
    }

    public static enum MarbleType implements StringRepresentable
    {
        DARK,
        WHITE,
        BLUE,
        GREEN,
        CARMIN;


        public static MarbleType byId(int id) {
            return id >= 0 && id < MarbleType.values().length ? MarbleType.values()[id] : MarbleType.getDefault();
        }

        public static MarbleType getDefault() {
            return DARK;
        }

        public Block getBlock() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ModBlocks.dark_marble;
                case 1 -> ModBlocks.white_marble;
                case 2 -> ModBlocks.blue_marble;
                case 3 -> ModBlocks.green_marble;
                case 4 -> ModBlocks.carmin_marble;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

