/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class BlockEntityWritableGrave
extends BlockEntity {
    @Nullable
    private UUID ownerId = null;
    protected String ownerName = "";
    protected long deathDate;
    protected long deathMCTime = 0L;
    public long countTicks = 0L;

    public BlockEntityWritableGrave(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public boolean canShowFog() {
        return ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal() != 0 && Optional.ofNullable(this.getLevel()).map(Helper::isNight).orElse(false) != false;
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, BlockEntityWritableGrave grave) {
        if (level.isClientSide() && grave.canShowFog() && grave.countTicks > 0L) {
            ProxyHelper.produceGraveSmoke(level, ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5, TimeHelper.isDateAroundHalloween() ? 0xFFFFFF : (Integer)ConfigTombstone.client.fogColor.get());
        }
        ++grave.countTicks;
    }

    public void setOwner(@Nullable UUID ownerId, String ownerName, long deathDate) {
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.deathDate = deathDate;
        Optional.ofNullable(this.getLevel()).ifPresent(l -> {
            this.deathMCTime = TimeHelper.worldTicks(l);
        });
    }

    public boolean isOwner(Player owner) {
        return Optional.ofNullable(this.ownerId).map(id -> id.equals(owner.getGameProfile().getId())).orElse(true);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return !this.ownerName.isEmpty();
    }

    public long getDeathMCTime() {
        return Optional.ofNullable(this.getLevel()).map(l -> {
            long worldTicks = TimeHelper.worldTicks(l);
            if (this.deathMCTime > worldTicks) {
                this.deathMCTime = worldTicks;
            }
            return worldTicks - this.deathMCTime;
        }).orElse(0L);
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0L;
        Optional.ofNullable(this.getLevel()).ifPresent(l -> {
            this.deathMCTime = TimeHelper.worldTicks(l);
        });
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.writeShared(valueOutput);
    }

    protected void writeShared(ValueOutput valueOutput) {
        if (this.ownerId != null) {
            SerializationHelper.setUUID(valueOutput, "owner_id", this.ownerId);
        }
        SerializationHelper.setString(valueOutput, "ownerName", this.ownerName);
        SerializationHelper.setLong(valueOutput, "deathDate", this.deathDate);
        SerializationHelper.setLong(valueOutput, "deathMCTime", this.deathMCTime);
        SerializationHelper.setLong(valueOutput, "countTicks", this.countTicks);
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.ownerId = SerializationHelper.getUUID(valueInput, "owner_id").orElse(null);
        SerializationHelper.getOptionalString(valueInput, "ownerName").ifPresent(s -> {
            this.ownerName = s;
        });
        this.deathDate = SerializationHelper.getLong(valueInput, "deathDate");
        this.deathMCTime = SerializationHelper.getLong(valueInput, "deathMCTime");
        long ticks = SerializationHelper.getLong(valueInput, "countTicks");
        this.countTicks = ticks == 0L ? (long)SerializationHelper.getInt(valueInput, "countTicks") : ticks;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        assert (this.level != null);
        return SerializationHelper.createCompoundTag(this::writeShared, this.level.registryAccess());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean triggerEvent(int id, int type) {
        return true;
    }
}

