/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.entity.ai.FollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.PacketHandler;

public class FriendlyAnimalHandler {
    private static final String OWNER_ID = "tb_friendly_animal_owner_id";

    public static boolean hasCapability(Entity entity) {
        return TamableType.FRIENDLY_ANIMAL.is(entity);
    }

    public static boolean hasOwner(Entity entity) {
        return entity.getPersistentData().contains(OWNER_ID);
    }

    public static Optional<UUID> getOwnerId(Entity entity) {
        return FriendlyAnimalHandler.hasOwner(entity) ? NBTHelper.getUUID(entity.getPersistentData(), OWNER_ID) : Optional.empty();
    }

    public static void setOwnerId(Entity entity, UUID ownerId) {
        NBTHelper.setUUID(entity.getPersistentData(), OWNER_ID, ownerId);
    }

    public static Optional<Player> getOwner(Entity entity) {
        return FriendlyAnimalHandler.getOwnerId(entity).map(ownerId -> entity.level().getPlayerByUUID(ownerId));
    }

    public static void setAI(PathfinderMob animal) {
        animal.setPersistenceRequired();
        animal.setCanPickUpLoot(true);
        EntityHelper.resetAttackAction((LivingEntity)animal);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            animal.setGuaranteedDrop(slot);
        }
        animal.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal((Mob)animal, 1.2, 20.0f, 3.0f, false){

            @Override
            protected Optional<Player> getOwner() {
                return FriendlyAnimalHandler.getOwner((Entity)this.mob);
            }
        });
        animal.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((Mob)animal){

            @Override
            protected Optional<Player> getOwner() {
                return FriendlyAnimalHandler.getOwner((Entity)this.mob);
            }
        });
        animal.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((Mob)animal){

            @Override
            protected Optional<Player> getOwner() {
                return FriendlyAnimalHandler.getOwner((Entity)this.mob);
            }
        });
        CallbackHandler.addFastCallback(() -> FriendlyAnimalHandler.getOwnerId((Entity)animal).ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new CMessageServant(animal.getId(), (UUID)ownerId, false), (LivingEntity)animal)));
    }
}

