/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEntities;

public class ProtectedEntityHandler {
    private static final Function<LivingEntity, GlobalPos> defaultSafeLocation = entity -> GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)entity.blockPosition().offset(Helper.RANDOM.nextInt(101) - 50, 0, Helper.RANDOM.nextInt(101) - 50));
    private static final String PROTECTED_ENTITY = "tb_protected_entity";

    public static boolean hasCapability(Entity entity) {
        EntityType entityType = entity.getType();
        return entityType == EntityType.VILLAGER || entityType == EntityType.WANDERING_TRADER || entityType == EntityType.IRON_GOLEM || entityType == ModEntities.grave_guardian || EntityHelper.isValidPlayer(entity);
    }

    public static boolean isActive(Entity entity) {
        return NBTHelper.getBoolean(entity.getPersistentData(), PROTECTED_ENTITY);
    }

    public static void setActive(Entity entity, boolean active) {
        NBTHelper.setBoolean(entity.getPersistentData(), PROTECTED_ENTITY, active);
    }

    public static void apply(LivingEntity entity, boolean active) {
        ProtectedEntityHandler.setActive((Entity)entity, active);
        if (!entity.level().isClientSide()) {
            PacketHandler.sendToAllTrackingPlayers(new CMessageProtection(entity.getId(), active), entity);
        }
    }

    public static GlobalPos getSafeLocation(LivingEntity entity) {
        if (entity.getType() == ModEntities.grave_guardian) {
            return ((GraveGuardian)entity).getHomePos();
        }
        return defaultSafeLocation.apply(entity);
    }
}

