/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.ai.FollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.entity.ai.spell.BuffOtherSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.CurseSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FangsSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FireBallSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.HealSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.ScorchSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SelfBuffSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellCastingGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.entity.ai.spell.ThunderSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WitherSkullSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WololoSpellGoal;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public class ServantUndeadHandler {
    private static final String OWNER_ID = "tb_servant_undead_owner_id";
    private static final String CASTER_TYPE = "tb_servant_undead_caster_type";

    public static boolean hasCapability(@Nullable Entity entity) {
        return TamableType.UNDEAD.is(entity);
    }

    public static boolean hasOwner(Entity entity) {
        return entity.getPersistentData().contains(OWNER_ID);
    }

    public static Optional<UUID> getOwnerId(Entity entity) {
        return ServantUndeadHandler.hasOwner(entity) ? NBTHelper.getUUID(entity.getPersistentData(), OWNER_ID) : Optional.empty();
    }

    public static void setOwnerId(Entity entity, UUID ownerId) {
        NBTHelper.setUUID(entity.getPersistentData(), OWNER_ID, ownerId);
    }

    public static Optional<Player> getOwner(Entity entity) {
        return ServantUndeadHandler.getOwnerId(entity).map(ownerId -> entity.level().getPlayerByUUID(ownerId));
    }

    public static boolean isSpellCaster(Entity entity) {
        return ServantUndeadHandler.getCasterType(entity) != CasterType.NONE.ordinal();
    }

    public static int getCasterType(Entity entity) {
        return NBTHelper.getShort(entity.getPersistentData(), CASTER_TYPE);
    }

    public static void setSpellCaster(Entity entity, int casterType) {
        NBTHelper.setShort(entity.getPersistentData(), CASTER_TYPE, (short)casterType);
    }

    public static void setAI(PathfinderMob servant) {
        servant.setPersistenceRequired();
        servant.setCanPickUpLoot(true);
        EntityHelper.resetAttackAction((LivingEntity)servant);
        servant.goalSelector.removeAllGoals(g -> !(g instanceof MeleeAttackGoal) && !(g instanceof RangedAttackGoal) && !(g instanceof RangedBowAttackGoal) && !(g instanceof RangedCrossbowAttackGoal) && !(g instanceof SpellCastingGoal) && !(g instanceof SpellUseGoal));
        servant.targetSelector.removeAllGoals(g -> true);
        servant.getBrain().removeAllBehaviors();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            servant.setGuaranteedDrop(slot);
        }
        servant.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)servant));
        servant.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((Mob)servant, 1.0, 10.0f, 2.5f, false){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.mob);
            }
        });
        servant.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal(servant, 1.0));
        servant.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)servant, Player.class, 8.0f));
        servant.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)servant));
        servant.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((Mob)servant){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.mob);
            }
        });
        servant.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((Mob)servant){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.mob);
            }
        });
        servant.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal(servant, new Class[]{Player.class}));
        if (ServantUndeadHandler.isSpellCaster((Entity)servant) && servant.goalSelector.getAvailableGoals().stream().noneMatch(g -> g.getGoal() instanceof SpellCastingGoal)) {
            servant.goalSelector.addGoal(1, (Goal)new SpellCastingGoal(servant));
            switch (CasterType.byId(ServantUndeadHandler.getCasterType((Entity)servant)).ordinal()) {
                case 2: {
                    servant.goalSelector.addGoal(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.goalSelector.addGoal(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.goalSelector.addGoal(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.WITHER, 200)));
                    servant.goalSelector.addGoal(5, (Goal)new WitherSkullSpellGoal(servant));
                    servant.goalSelector.addGoal(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLACK));
                    break;
                }
                case 1: {
                    servant.goalSelector.addGoal(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.goalSelector.addGoal(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.goalSelector.addGoal(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.LEVITATION, 200)));
                    servant.goalSelector.addGoal(5, (Goal)new ThunderSpellGoal(servant));
                    servant.goalSelector.addGoal(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLUE));
                    break;
                }
                case 3: {
                    servant.goalSelector.addGoal(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 2400, 3)));
                    servant.goalSelector.addGoal(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 2400, 3)));
                    servant.goalSelector.addGoal(4, (Goal)new ScorchSpellGoal(servant));
                    servant.goalSelector.addGoal(5, (Goal)new FireBallSpellGoal(servant));
                    servant.goalSelector.addGoal(6, (Goal)new WololoSpellGoal(servant, DyeColor.ORANGE));
                    break;
                }
                case 4: {
                    servant.goalSelector.addGoal(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.goalSelector.addGoal(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.goalSelector.addGoal(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.SLOWNESS, 200, 2)));
                    servant.goalSelector.addGoal(5, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(ModEffects.frostbite, 200, 2)));
                    servant.goalSelector.addGoal(6, (Goal)new WololoSpellGoal(servant, DyeColor.WHITE));
                    break;
                }
                case 5: {
                    servant.goalSelector.addGoal(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(MobEffects.RESISTANCE, 2400, 2)));
                    servant.goalSelector.addGoal(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(MobEffects.RESISTANCE, 2400, 2)));
                    servant.goalSelector.addGoal(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.WEAKNESS, 200, 2)));
                    servant.goalSelector.addGoal(5, (Goal)new FangsSpellGoal(servant));
                    servant.goalSelector.addGoal(6, (Goal)new WololoSpellGoal(servant, DyeColor.GREEN));
                }
            }
            servant.goalSelector.addGoal(6, (Goal)new HealSpellGoal(servant));
        }
        servant.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal<Mob>((Mob)servant, Mob.class, 20, true, false, (target, serverLevel) -> target instanceof Enemy && !servant.isAlliedTo((Entity)target)){

            protected double getFollowDistance() {
                return 7.0;
            }
        });
        CallbackHandler.addFastCallback(() -> ServantUndeadHandler.getOwnerId((Entity)servant).ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new CMessageServant(servant.getId(), (UUID)ownerId, true), (LivingEntity)servant)));
    }

    public static enum CasterType {
        NONE,
        LIGHTNING,
        DARKNESS,
        FIRE,
        FROST,
        EARTH;


        public static CasterType getDefault() {
            return NONE;
        }

        public static CasterType byId(int id) {
            return id >= 0 && id < CasterType.values().length ? CasterType.values()[id] : CasterType.getDefault();
        }

        public static int getRandomId() {
            return Helper.RANDOM.nextInt(CasterType.values().length - 1) + 1;
        }

        public static CasterType getRandom() {
            return CasterType.byId(CasterType.getRandomId());
        }
    }
}

