/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEntities;

public class SpellCasterHandler {
    private static final String SPELLCASTER_CASTING_TIME = "tb_spellcaster_casting_time";
    private static final String SPELLCASTER_CASTING_COLOR = "tb_spellcaster_casting_color";
    private static final String SPELLCASTER_CASTING_COOLDOWN = "tb_spellcaster_casting_cooldown";
    private static final String SPELLCASTER_SPECIAL_TARGET = "tb_spellcaster_special_target";

    public static boolean hasCapability(@Nullable LivingEntity entity) {
        return entity != null && (entity.getType() == ModEntities.grave_guardian || TamableType.UNDEAD.is((Entity)entity));
    }

    public static boolean isCasting(LivingEntity caster) {
        return SpellCasterHandler.getCastingColor(caster) > 0;
    }

    private static int getCastingTime(LivingEntity caster) {
        return NBTHelper.getInt(caster.getPersistentData(), SPELLCASTER_CASTING_TIME);
    }

    private static void setCastingTime(LivingEntity caster, int castingTime) {
        caster.getPersistentData().putInt(SPELLCASTER_CASTING_TIME, castingTime);
    }

    public static void startCasting(LivingEntity caster, int castingTime, int castingColor) {
        CompoundTag persistentData = caster.getPersistentData();
        persistentData.putInt(SPELLCASTER_CASTING_TIME, castingTime);
        persistentData.putInt(SPELLCASTER_CASTING_COLOR, castingColor);
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.getId(), castingColor), caster);
        caster.playSound(SpellCasterHandler.getCastingSoundEvent(), 1.0f, 1.0f);
    }

    private static void stopCasting(LivingEntity caster) {
        CompoundTag persistentData = caster.getPersistentData();
        persistentData.remove(SPELLCASTER_CASTING_TIME);
        persistentData.remove(SPELLCASTER_CASTING_COLOR);
        persistentData.remove(SPELLCASTER_SPECIAL_TARGET);
        SpellCasterHandler.setSpellCooldown(caster, 60);
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.getId(), 0), caster);
    }

    public static int getCastingColor(LivingEntity caster) {
        return NBTHelper.getInt(caster.getPersistentData(), SPELLCASTER_CASTING_COLOR);
    }

    public static void setCastingColor(LivingEntity caster, int castingColor) {
        caster.getPersistentData().putInt(SPELLCASTER_CASTING_COLOR, castingColor);
    }

    public static boolean hasSpellCooldown(LivingEntity caster) {
        return SpellCasterHandler.getCastingCooldown(caster) > 0;
    }

    private static int getCastingCooldown(LivingEntity caster) {
        return NBTHelper.getInt(caster.getPersistentData(), SPELLCASTER_CASTING_COOLDOWN);
    }

    private static void setSpellCooldown(LivingEntity caster, int castingCooldown) {
        caster.getPersistentData().putInt(SPELLCASTER_CASTING_COOLDOWN, castingCooldown);
    }

    public static Optional<LivingEntity> getSpecialTarget(LivingEntity caster) {
        CompoundTag persistentData;
        if (SpellCasterHandler.hasCapability(caster) && (persistentData = caster.getPersistentData()).contains(SPELLCASTER_SPECIAL_TARGET)) {
            return Optional.ofNullable(caster.level().getEntity(NBTHelper.getInt(persistentData, SPELLCASTER_SPECIAL_TARGET))).filter(Entity::isAlive).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
        }
        return Optional.empty();
    }

    public static void setSpecialTarget(LivingEntity caster, @Nullable LivingEntity specialTarget) {
        CompoundTag persistentData = caster.getPersistentData();
        if (specialTarget == null) {
            persistentData.remove(SPELLCASTER_SPECIAL_TARGET);
        } else if (specialTarget.isAlive()) {
            persistentData.putInt(SPELLCASTER_SPECIAL_TARGET, specialTarget.getId());
        }
    }

    public static void tick(LivingEntity caster) {
        if (!caster.level().isClientSide()) {
            int castingCooldown = SpellCasterHandler.getCastingCooldown(caster);
            if (castingCooldown > 0) {
                SpellCasterHandler.setSpellCooldown(caster, --castingCooldown);
            } else {
                int castingTime = SpellCasterHandler.getCastingTime(caster);
                if (castingTime > 0) {
                    SpellCasterHandler.setCastingTime(caster, --castingTime);
                    if (castingTime == 0) {
                        SpellCasterHandler.stopCasting(caster);
                    }
                }
            }
        }
    }

    private static SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }
}

