/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkBranch;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBPlayerCapabilityHandler {
    private static final Map<UUID, CachedData> SERVER_CACHE = new ConcurrentHashMap<UUID, CachedData>();
    private static final CachedData CLIENT_CACHE = new CachedData(0, 0, new ConcurrentHashMap<Perk, Integer>(), new BitSet());
    private static final String KNOWLEDGE = "knowledge";
    private static final String ALIGNMENT = "alignment";
    private static final String WATCHER_KNOWLEDGE = "watcher_knowledge";

    private static CachedData getCache(Player player) {
        return player.level().isClientSide ? CLIENT_CACHE : SERVER_CACHE.computeIfAbsent(player.getUUID(), uuid -> TBPlayerCapabilityHandler.loadCache((ServerPlayer)player));
    }

    private static CachedData loadCache(ServerPlayer serverPlayer) {
        CompoundTag tag = EntityHelper.getTombstoneTag((Player)serverPlayer);
        int knowledge = NBTHelper.getInt(tag, KNOWLEDGE);
        short alignment = NBTHelper.getShort(tag, ALIGNMENT);
        BitSet watcherKnowledge = BitSet.valueOf(tag.getByteArray(WATCHER_KNOWLEDGE).orElse(new byte[0]));
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        NBTHelper.readPerks(perks, tag);
        return new CachedData(knowledge, alignment, perks, watcherKnowledge);
    }

    private static void saveCache(ServerPlayer serverPlayer) {
        CachedData cache = TBPlayerCapabilityHandler.getCache((Player)serverPlayer);
        CompoundTag tag = EntityHelper.getTombstoneTag((Player)serverPlayer);
        NBTHelper.setInt(tag, KNOWLEDGE, cache.knowledge);
        NBTHelper.setShort(tag, ALIGNMENT, (short)cache.alignment);
        tag.putByteArray(WATCHER_KNOWLEDGE, cache.watcherKnowledge.toByteArray());
        NBTHelper.writePerks(cache.perks, tag);
    }

    public static void clearServerCache(ServerPlayer serverPlayer) {
        SERVER_CACHE.remove(serverPlayer.getUUID());
    }

    public static void clearAllServerCache() {
        SERVER_CACHE.clear();
    }

    public static void onClone(ServerPlayer original, ServerPlayer newPlayer) {
        TBPlayerCapabilityHandler.getCache((Player)original);
        TBPlayerCapabilityHandler.saveCache(newPlayer);
    }

    public static int getKnowledge(Player player) {
        return TBPlayerCapabilityHandler.getCache((Player)player).knowledge;
    }

    public static void setKnowledge(Player player, int points) {
        if (points < 0) {
            return;
        }
        TBPlayerCapabilityHandler.getCache((Player)player).knowledge = points;
        if (!player.level().isClientSide()) {
            NBTHelper.setInt(EntityHelper.getTombstoneTag(player), KNOWLEDGE, points);
        }
    }

    public static void rewardKnowledge(ServerPlayer player, int knowledge) {
        if (EntityHelper.isValidServerPlayer(player) && knowledge > 0) {
            int newPerkPoints;
            int earnedPerkPoints;
            int oldPerkPoints = TBPlayerCapabilityHandler.getTotalPerkPoints((Player)player);
            TBPlayerCapabilityHandler.setKnowledge((Player)player, TBPlayerCapabilityHandler.getKnowledge((Player)player) + knowledge);
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_INCREASE_OF.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
            }
            if ((earnedPerkPoints = (newPerkPoints = TBPlayerCapabilityHandler.getTotalPerkPoints((Player)player)) - oldPerkPoints) > 0) {
                PacketHandler.sendToPlayer(new CMessageLevelUp(earnedPerkPoints), player);
                if (oldPerkPoints == 0) {
                    ModTriggers.first_knowledge.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.mastery_1.trigger(player);
                }
                if (oldPerkPoints < 20 && newPerkPoints >= 20) {
                    ModTriggers.mastery_2.trigger(player);
                }
                if (oldPerkPoints < 30 && newPerkPoints >= 30) {
                    ModTriggers.mastery_3.trigger(player);
                }
            }
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(TBPlayerCapabilityHandler.getKnowledge((Player)player)), player);
        }
    }

    public static void loseKnowledge(ServerPlayer player, int points) {
        if (!EntityHelper.isValidServerPlayer(player) || points <= 0) {
            return;
        }
        int oldPerkPoints = TBPlayerCapabilityHandler.getTotalPerkPoints((Player)player);
        TBPlayerCapabilityHandler.setKnowledge((Player)player, TBPlayerCapabilityHandler.getKnowledge((Player)player) - points);
        int lostPerkPoints = oldPerkPoints - TBPlayerCapabilityHandler.getTotalPerkPoints((Player)player);
        if (lostPerkPoints <= 0) {
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(TBPlayerCapabilityHandler.getKnowledge((Player)player)), player);
            return;
        }
        Map<Perk, Integer> perks = TBPlayerCapabilityHandler.getPerks((Player)player);
        List<Perk> orderedPerks = perks.keySet().stream().sorted(Comparator.comparingInt(Perk::getBranchTier).reversed()).toList();
        for (Perk perk : orderedPerks) {
            if (perk.isDisabled((Player)player)) {
                perks.remove(perk);
                continue;
            }
            int perkLevel = TBPlayerCapabilityHandler.getPerkLevel((Player)player, perk);
            while (perkLevel > 0 && lostPerkPoints > 0) {
                int cost = perk.getCost(perkLevel);
                lostPerkPoints -= cost;
                if (--perkLevel == 0) {
                    perks.remove(perk);
                    continue;
                }
                perks.put(perk, perkLevel);
            }
            if (lostPerkPoints > 0) continue;
            break;
        }
        TBPlayerCapabilityHandler.setPerks((Player)player, perks);
        EntityHelper.syncPlayerCapability(player);
        if (PlayerPreference.get(player).displayKnowledgeMessage()) {
            LangKey.MESSAGE_DECREASE_OF.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
        }
    }

    public static int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    public static int getAlignmentValue(Player player) {
        return TBPlayerCapabilityHandler.getCache((Player)player).alignment;
    }

    public static int getAlignmentMinValue() {
        return -5000;
    }

    public static int getAlignmentMaxValue() {
        return 5000;
    }

    public static void setAlignment(Player player, int value) {
        TBPlayerCapabilityHandler.getCache((Player)player).alignment = value;
        if (!player.level().isClientSide()) {
            NBTHelper.setShort(EntityHelper.getTombstoneTag(player), ALIGNMENT, (short)value);
        }
    }

    public static int getAlignmentLevel(Player player) {
        int alignment = TBPlayerCapabilityHandler.getAlignmentValue(player);
        if (alignment <= TBPlayerCapabilityHandler.getAlignmentMinValue()) {
            return -4;
        }
        if (alignment <= -3000) {
            return -3;
        }
        if (alignment <= -1500) {
            return -2;
        }
        if (alignment <= -500) {
            return -1;
        }
        if (alignment < 500) {
            return 0;
        }
        if (alignment < 1500) {
            return 1;
        }
        if (alignment < 3000) {
            return 2;
        }
        if (alignment < TBPlayerCapabilityHandler.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    public static void rewardAlignment(ServerPlayer player, int alignment) {
        if (EntityHelper.isValidServerPlayer(player) && alignment != 0) {
            if (PlayerPreference.get(player).displayAlignmentMessage()) {
                (alignment > 0 ? LangKey.MESSAGE_INCREASE_OF : LangKey.MESSAGE_DECREASE_OF).sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_ALIGNMENT.getText(new Object[0]), Math.abs(alignment)});
            }
            int oldAlignment = TBPlayerCapabilityHandler.getAlignmentLevel((Player)player);
            if (alignment > 0 && oldAlignment < 0 || alignment < 0 && oldAlignment > 0) {
                alignment *= 2;
            }
            TBPlayerCapabilityHandler.setAlignment((Player)player, TBPlayerCapabilityHandler.getAlignmentValue((Player)player) + alignment);
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncAlignment(TBPlayerCapabilityHandler.getAlignmentValue((Player)player)), player);
        }
    }

    public static Map<PerkBranch, BranchUsage> getUsedPointsByBranch(Player player) {
        Map usedPointsByBranch = Arrays.stream(PerkBranch.values()).collect(Collectors.toMap(Function.identity(), b -> new BranchUsage(0, 0), (a, b) -> a, () -> new EnumMap(PerkBranch.class)));
        Iterator<Map.Entry<Perk, Integer>> it = TBPlayerCapabilityHandler.getPerks(player).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (entry.getKey().isDisabled(player)) {
                it.remove();
                continue;
            }
            int usedPoints = 0;
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                usedPoints += entry.getKey().getCost(i);
            }
            usedPointsByBranch.put(entry.getKey().getBranch(), ((BranchUsage)usedPointsByBranch.get((Object)entry.getKey().getBranch())).add(usedPoints, entry.getValue()));
        }
        return usedPointsByBranch;
    }

    public static int getTotalUsedPerkPoints(Player player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = TBPlayerCapabilityHandler.getPerks(player).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (entry.getKey().isDisabled(player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    public static int getTotalPerkPoints(Player player) {
        return (int)Mth.sqrt((float)(TBPlayerCapabilityHandler.getKnowledge(player) - 1));
    }

    public static Map<Perk, Integer> getPerks(Player player) {
        return TBPlayerCapabilityHandler.getCache((Player)player).perks;
    }

    public static void setPerks(Player player, Map<Perk, Integer> perks) {
        TBPlayerCapabilityHandler.getCache((Player)player).perks = perks;
        if (!player.level().isClientSide()) {
            NBTHelper.writePerks(perks, EntityHelper.getTombstoneTag(player));
        }
    }

    public static void setPerk(Player player, Perk perk, int level) {
        Map<Perk, Integer> perks = TBPlayerCapabilityHandler.getPerks(player);
        perks.put(perk, level);
        if (!player.level().isClientSide()) {
            NBTHelper.writePerks(perks, EntityHelper.getTombstoneTag(player));
        }
    }

    public static void removePerk(Player player, Perk perk) {
        Map<Perk, Integer> perks = TBPlayerCapabilityHandler.getPerks(player);
        perks.remove(perk);
        if (!player.level().isClientSide()) {
            NBTHelper.writePerks(perks, EntityHelper.getTombstoneTag(player));
        }
    }

    public static int getPerkLevel(Player player, Perk perk) {
        return perk.isDisabled(player) ? 0 : TBPlayerCapabilityHandler.getPerks(player).getOrDefault(perk, 0);
    }

    public static int getPerkLevelWithBonus(Player player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(TBPlayerCapabilityHandler.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    public static boolean canUpgradePerk(Player player, Perk perk) {
        if (perk.isDisabled(player)) {
            return false;
        }
        if (perk.getParent() != null && TBPlayerCapabilityHandler.getPerkLevel(player, perk.getParent()) == 0) {
            return false;
        }
        int perkLevel = TBPlayerCapabilityHandler.getPerkLevel(player, perk);
        if (perkLevel >= perk.getLevelMax()) {
            return false;
        }
        Map<PerkBranch, BranchUsage> usedPerkPointsByBranch = TBPlayerCapabilityHandler.getUsedPointsByBranch(player);
        if (!EntityHelper.hasPerkBranchTierRequirement(perk, usedPerkPointsByBranch.get((Object)((Object)perk.getBranch())).perkPoints)) {
            return false;
        }
        int usedPerkPoints = usedPerkPointsByBranch.values().stream().mapToInt(u -> u.usedPoints).sum();
        return TBPlayerCapabilityHandler.getTotalPerkPoints(player) - usedPerkPoints >= perk.getCost(perkLevel + 1);
    }

    public static boolean canDowngradePerk(Player player, Perk perk) {
        return player.isCreative() && !perk.isDisabled(player) && TBPlayerCapabilityHandler.getPerks(player).keySet().stream().noneMatch(currentPerk -> currentPerk.getParent() == perk) && TBPlayerCapabilityHandler.getPerkLevel(player, perk) > 0;
    }

    public static void resetPerks(ServerPlayer player) {
        TBPlayerCapabilityHandler.setPerks((Player)player, new ConcurrentHashMap<Perk, Integer>());
        EntityHelper.syncPlayerCapability(player);
    }

    public static boolean hasWatcherKnowledge(Player player, int id) {
        return TBPlayerCapabilityHandler.getWatcherKnowledge(player).get(id);
    }

    public static BitSet getWatcherKnowledge(Player player) {
        return TBPlayerCapabilityHandler.getCache((Player)player).watcherKnowledge;
    }

    public static void unlockWatcherKnowledge(Player player, int id) {
        BitSet watcherKnowledge = TBPlayerCapabilityHandler.getWatcherKnowledge(player);
        watcherKnowledge.set(id, true);
        if (!player.level().isClientSide()) {
            EntityHelper.getTombstoneTag(player).putByteArray(WATCHER_KNOWLEDGE, watcherKnowledge.toByteArray());
        }
    }

    public static void updateWatcherKnowledge(Player player, BitSet watcherKnowledge) {
        TBPlayerCapabilityHandler.getCache((Player)player).watcherKnowledge = watcherKnowledge;
        if (!player.level().isClientSide()) {
            EntityHelper.getTombstoneTag(player).putByteArray(WATCHER_KNOWLEDGE, watcherKnowledge.toByteArray());
        }
    }

    private static class CachedData {
        public int knowledge;
        public int alignment;
        public Map<Perk, Integer> perks;
        public BitSet watcherKnowledge;

        public CachedData(int knowledge, int alignment, Map<Perk, Integer> perks, BitSet watcherKnowledge) {
            this.knowledge = knowledge;
            this.alignment = alignment;
            this.perks = perks;
            this.watcherKnowledge = watcherKnowledge;
        }
    }

    public static class BranchUsage {
        public int usedPoints;
        public int perkPoints;

        BranchUsage(int usedPoints, int perkPoints) {
            this.usedPoints = usedPoints;
            this.perkPoints = perkPoints;
        }

        BranchUsage add(int usedPoints, int perkPoints) {
            this.usedPoints += usedPoints;
            this.perkPoints += perkPoints;
            return this;
        }
    }
}

