/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;

public final class CommandTBShowLastGrave
extends TombstoneCommand {
    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.SHOW_LAST_GRAVE;
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::getLastGrave)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(this.defaultPermission)).executes(this::getLastGrave));
    }

    private int getLastGrave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = this.defaultPermission.test((CommandSourceStack)ctx.getSource()) ? CommandTBShowLastGrave.getPlayerOrCommandSender(ctx, "player") : ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(((CommandSourceStack)ctx.getSource()).getServer(), target);
        if (lastGrave.isOrigin()) {
            lastGrave = ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((Player)target, ModItems.grave_key));
        }
        if (lastGrave.isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_LAST_GRAVE_PLACE.getText(target.getGameProfile().getName(), LangKey.MESSAGE_LAST_GRAVE.getText(new Object[0]), lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.getDimString()), false);
        return 1;
    }
}

