/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.registry.ModItems;

public final class CommandTBTeleport
extends TombstoneCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(s -> Component.translatable((String)"commands.locate.invalid", (Object[])new Object[]{s}));
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(structure -> Component.translatable((String)"commands.locate.structure.invalid", (Object[])new Object[]{structure}));

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.TELEPORT;
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    protected Component getUsage() {
        return Component.translatable((String)("tombstone.command." + String.valueOf((Object)this.getCommandName()) + ".default.usage"));
    }

    private int showUsage(CommandSourceStack source, SubCommand subCmd) {
        source.sendSuccess(() -> Component.translatable((String)("tombstone.command." + String.valueOf((Object)this.getCommandName()) + "." + subCmd.name().toLowerCase(Locale.ROOT) + ".usage")), false);
        return 1;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        builder.executes(this::showUsage);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.POS.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.POS))).then(((RequiredArgumentBuilder)Commands.argument((String)"source", (ArgumentType)EntityArgument.entity()).executes(this::showUsage)).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> {
            Entity source = EntityArgument.getEntity((CommandContext)c, (String)"source");
            BlockPos pos = BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"pos");
            return this.teleport((CommandSourceStack)c.getSource(), source, pos.getX(), pos.getY(), pos.getZ(), (ServerLevel)source.level());
        })).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(c -> {
            BlockPos pos = BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"pos");
            return this.teleport((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"source"), pos.getX(), pos.getY(), pos.getZ(), DimensionArgument.getDimension((CommandContext)c, (String)"dim"));
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.PLAYER.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.PLAYER))).then(((RequiredArgumentBuilder)Commands.argument((String)"source", (ArgumentType)EntityArgument.entity()).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.PLAYER))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(c -> {
            Entity target = EntityArgument.getEntity((CommandContext)c, (String)"target");
            BlockPos targetPos = target.blockPosition();
            return this.teleport((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"source"), targetPos.getX(), targetPos.getY(), targetPos.getZ(), (ServerLevel)target.level());
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.GRAVE.literal().requires(this.defaultPermission)).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), ((CommandSourceStack)c.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), EntityArgument.getPlayer((CommandContext)c, (String)"player")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"player"), EntityArgument.getPlayer((CommandContext)c, (String)"target"))))))).then(SubCommand.DEATH.literal().executes(c -> this.teleportDeath((CommandSourceStack)c.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.HOME.literal().requires(this.defaultPermission)).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), ((CommandSourceStack)c.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), EntityArgument.getPlayer((CommandContext)c, (String)"player")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"player"), EntityArgument.getPlayer((CommandContext)c, (String)"target"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.DISCOVERY.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.DISCOVERY))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"target"), (HolderSet<Structure>)((HolderSet)WorldHelper.asHolderSet(((CommandSourceStack)c.getSource()).getLevel(), (TagKey<Structure>)StructureTags.VILLAGE).get())))).then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"target"), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID)))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"target"), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID), DimensionArgument.getDimension((CommandContext)c, (String)"dim")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.BIOME.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.argument((String)"biome", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.BIOME)).executes(c -> this.teleportBiome((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"target"), (ResourceOrTagArgument.Result<Biome>)ResourceOrTagArgument.getResourceOrTag((CommandContext)c, (String)"biome", (ResourceKey)Registries.BIOME)))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(c -> this.teleportBiome((CommandSourceStack)c.getSource(), EntityArgument.getEntity((CommandContext)c, (String)"target"), (ResourceOrTagArgument.Result<Biome>)ResourceOrTagArgument.getResourceOrTag((CommandContext)c, (String)"biome", (ResourceKey)Registries.BIOME), DimensionArgument.getDimension((CommandContext)c, (String)"dim")))))));
        return builder;
    }

    private void onTeleport(CommandSourceStack sender, Entity source, Location destination, ServerLevel targetWorld) {
        Entity newEntity = Helper.teleport(source, destination, targetWorld);
        if (EntityHelper.isValidServerPlayer(newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((ServerPlayer)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.getName(), destination.x, destination.y, destination.z, destination.getDimString()), false);
    }

    private int teleport(CommandSourceStack sender, Entity source, int x, int y, int z, ServerLevel targetWorld) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive(source);
        CommandTBTeleport.checkNotSpectator(source);
        Location sourceLoc = new Location(source);
        Location destLoc = new Location(x, y, z, (Level)targetWorld);
        if (sourceLoc.equals(destLoc)) {
            throw LangKey.MESSAGE_SAME_LOCATION.asCommandException(new Object[0]);
        }
        CommandTBTeleport.checkValidPos((Level)targetWorld, destLoc.getPos());
        destLoc = new SpawnHelper(targetWorld, WorldHelper.getCloserValidPos((Level)targetWorld, destLoc.getPos())).findSpawnPlace();
        if (destLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, source, destLoc, targetWorld);
        return 1;
    }

    private int teleportGrave(CommandSourceStack sender, ServerPlayer player, ServerPlayer target) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        MinecraftServer server = sender.getServer();
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(server, target);
        if (lastGrave.isOrigin() && (lastGrave = ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((Player)target, ModItems.grave_key))).isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        ServerLevel targetWorld = this.getOrThrowWorld(server, lastGrave.dim);
        CommandTBTeleport.checkValidPos((Level)targetWorld, lastGrave.getPos());
        Location spawnPos = new SpawnHelper(targetWorld, lastGrave.move(Direction.UP, 1).getPos()).findSpawnPlace();
        if (spawnPos.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, (Entity)player, spawnPos, targetWorld);
        return 1;
    }

    private int teleportDeath(CommandSourceStack sender) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportDeath.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayer player = sender.getPlayerOrException();
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        GlobalPos lastDeathLocation = (GlobalPos)player.getLastDeathLocation().orElseThrow(() -> LangKey.MESSAGE_NO_DEATH_LOCATION.asCommandException(new Object[0]));
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownHandler.CooldownType.TELEPORT_DEATH);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage(player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        ServerLevel world = this.getOrThrowWorld(sender.getServer(), (ResourceKey<Level>)lastDeathLocation.dimension());
        Location location = new SpawnHelper(world, lastDeathLocation.pos()).findSpawnPlace();
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        CooldownHandler.INSTANCE.setMaxCooldown(player, CooldownHandler.CooldownType.TELEPORT_DEATH);
        this.onTeleport(sender, (Entity)player, location, world);
        return 1;
    }

    private int teleportHome(CommandSourceStack sender, ServerPlayer player, ServerPlayer target) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Entity)player);
        Pair<ServerLevel, BlockPos> spawnPoint = CommandTBTeleport.getRespawnPoint(sender.getServer(), target);
        Location location = new SpawnHelper((ServerLevel)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight()).findSpawnPlace();
        CommandTBTeleport.checkValidPos((Level)spawnPoint.getLeft(), location.getPos());
        this.onTeleport(sender, (Entity)player, location, (ServerLevel)spawnPoint.getLeft());
        return 1;
    }

    public static Pair<ServerLevel, BlockPos> getRespawnPoint(MinecraftServer server, ServerPlayer player) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ServerPlayer.RespawnConfig respawnConfig = player.getRespawnConfig();
        if (respawnConfig != null) {
            BlockPos spawnPos = respawnConfig.pos();
            ServerLevel world = server.getLevel(respawnConfig.dimension());
            if (world != null) {
                return Pair.of((Object)world, (Object)spawnPos);
            }
        }
        ServerLevel overworld = server.overworld();
        return Pair.of((Object)overworld, (Object)overworld.getSharedSpawnPos());
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, ResourceOrTagKeyArgument.Result<Structure> structureResult) throws CommandSyntaxException {
        return this.teleportDiscovery(sender, target, structureResult, (ServerLevel)target.level());
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, ResourceOrTagKeyArgument.Result<Structure> structureResult, ServerLevel world) throws CommandSyntaxException {
        Registry registry = sender.getLevel().registryAccess().lookupOrThrow(Registries.STRUCTURE);
        HolderSet holderset = (HolderSet)((Optional)structureResult.unwrap().map(k -> registry.get(k).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), arg_0 -> ((Registry)registry).get(arg_0))).orElseThrow(() -> ERROR_INVALID.create((Object)structureResult.asPrintable()));
        return this.teleportDiscovery(sender, target, (HolderSet<Structure>)holderset, world);
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, HolderSet<Structure> holderset) throws CommandSyntaxException {
        return this.teleportDiscovery(sender, target, holderset, (ServerLevel)target.level());
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, HolderSet<Structure> holderset, ServerLevel world) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        Pair<Location, ResourceLocation> res = WorldHelper.findNearestStructure(world, target.blockPosition().offset((int)(Helper.RANDOM.nextGaussian() * 2000.0), 0, (int)(Helper.RANDOM.nextGaussian() * 2000.0)), holderset, true);
        if (((Location)res.getLeft()).isOrigin()) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, ((Location)res.getLeft()).getPos()).findStructurePlace((ResourceLocation)res.getRight());
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private int teleportBiome(CommandSourceStack sender, Entity target, ResourceOrTagArgument.Result<Biome> biomeResult) throws CommandSyntaxException {
        return this.teleportBiome(sender, target, biomeResult, (ServerLevel)target.level());
    }

    private int teleportBiome(CommandSourceStack sender, Entity target, ResourceOrTagArgument.Result<Biome> biomeResult, ServerLevel world) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        Location location = WorldHelper.findNearestBiome(world, target.blockPosition(), biomeResult);
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIOME.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        POS,
        PLAYER,
        GRAVE,
        DEATH,
        HOME,
        DISCOVERY,
        BIOME;

    }
}

