/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class CompatibilityCurio {
    public static final CompatibilityCurio instance = new CompatibilityCurio();

    private CompatibilityCurio() {
    }

    public void autoEquip(ServerPlayer player, ItemStackHandler itemHandler, List<Integer> ids) {
        Map map = Optional.ofNullable((ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY)).map(ICuriosItemHandler::getCurios).orElse(null);
        if (map == null) {
            return;
        }
        ListIterator<Integer> idIterator = ids.listIterator(ids.size());
        block0: while (idIterator.hasPrevious()) {
            int slotId = idIterator.previous();
            ItemStack stack = itemHandler.getStackInSlot(slotId);
            Set tags = CuriosApi.getItemStackSlots((ItemStack)stack, (Level)player.level()).keySet();
            if (tags.isEmpty()) continue;
            ListIterator tagIterator = new ArrayList(tags).listIterator(tags.size());
            while (tagIterator.hasPrevious()) {
                ICurioStacksHandler curioStacksHandler = (ICurioStacksHandler)map.get(tagIterator.previous());
                if (curioStacksHandler == null || !this.autoEquip(curioStacksHandler, stack)) continue;
                itemHandler.setStackInSlot(slotId, ItemStack.EMPTY);
                idIterator.remove();
                continue block0;
            }
        }
    }

    private boolean autoEquip(ICurioStacksHandler curioStacksHandler, ItemStack stack) {
        IDynamicStackHandler dynamicStacks = curioStacksHandler.getStacks();
        for (int i = curioStacksHandler.getSlots() - 1; i >= 0; --i) {
            if (!dynamicStacks.getStackInSlot(i).isEmpty() || !dynamicStacks.isItemValid(i, stack)) continue;
            dynamicStacks.setStackInSlot(i, stack.copy());
            return true;
        }
        return false;
    }
}

