/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.block.entity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModBlocks;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public final class IntegrationJade
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registrar) {
        registrar.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public ResourceLocation getUid() {
                return ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_graves");
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                try {
                    BlockEntity tile;
                    if (ModBlocks.isPlayerGrave(accessor.getBlock()) && (tile = accessor.getBlockEntity()) instanceof BlockEntityPlayerGrave) {
                        BlockEntityPlayerGrave grave = (BlockEntityPlayerGrave)tile;
                        tooltip.add((Component)Component.literal((String)grave.getFormattedInfo()));
                        tooltip.add((Component)Component.literal((String)grave.getFormattedDeathDate()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, BlockGrave.class);
        registrar.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public ResourceLocation getUid() {
                return ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"decorative_graves");
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                try {
                    BlockEntity tile;
                    if (ModBlocks.isDecorativeGrave(accessor.getBlock()) && (tile = accessor.getBlockEntity()) instanceof BlockEntityDecorativeGrave) {
                        BlockEntityDecorativeGrave grave = (BlockEntityDecorativeGrave)tile;
                        int corruption = grave.getCorruptionLevel();
                        tooltip.add((Component)LangKey.TOOLTIP_CORRUPTION.getText(corruption < 30 ? StyleType.COLOR_GREEN : (corruption > 70 ? StyleType.COLOR_RED : StyleType.COLOR_ORANGE), new Object[]{corruption}));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, BlockDecorativeGrave.class);
    }
}

