/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.compatibility.CombineRecipeCategory;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public final class IntegrationJustEnoughItem
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"jei_integration");
    private final IRecipeType<CombineRecipeCategory.JeiCombineRecipe> recipeType = IRecipeType.create((String)"tombstone", (String)"combine", CombineRecipeCategory.JeiCombineRecipe.class);

    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CombineRecipeCategory(this.recipeType, registry.getJeiHelpers().getGuiHelper())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ImmutableList.Builder combineBuilder = ImmutableList.builder();
        combineBuilder.add((Object)new CombineRecipeCategory.JeiCombineRecipe(new ItemStack((ItemLike)ModItems.receptacle_of_familiar), ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), "minecraft:cat"), ModItems.receptacle_of_familiar.setCapturableType(new ItemStack((ItemLike)ModItems.receptacle_of_familiar), "minecraft:cat")));
        this.addCombinations((ImmutableList.Builder<CombineRecipeCategory.JeiCombineRecipe>)combineBuilder, ModItems.grave_key);
        this.addCombinations((ImmutableList.Builder<CombineRecipeCategory.JeiCombineRecipe>)combineBuilder, ModItems.grave_dust);
        this.addCombinations((ImmutableList.Builder<CombineRecipeCategory.JeiCombineRecipe>)combineBuilder, ModItems.strange_scroll);
        this.addCombinations((ImmutableList.Builder<CombineRecipeCategory.JeiCombineRecipe>)combineBuilder, ModItems.strange_tablet);
        ModBlocks.DECORATIVE_GRAVES.values().forEach(decorativeGrave -> {
            for (BlockGraveMarble.MarbleType type : BlockGraveMarble.MarbleType.values()) {
                ItemStack graveStack = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)decorativeGrave), type.ordinal());
                combineBuilder.add((Object)new CombineRecipeCategory.JeiCombineRecipe(graveStack, EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.memorial_plaque), "Unknown"), EngravableHelper.setEngravedName(graveStack.copy(), "Unknown")));
            }
        });
        registration.addRecipes(this.recipeType, (List)combineBuilder.build());
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        builder.add((Object)factory.createAnvilRecipe(new ItemStack((ItemLike)ModItems.memorial_plaque), Helper.getStackList((TagKey<Item>)Tags.Items.INGOTS_IRON), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.memorial_plaque), "Unknown")), ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"engraved_memorial_plaque")));
        ItemStack tablet = new ItemStack((ItemLike)ModItems.tablet_of_assistance);
        tablet.set(ModDataComponents.ENCHANTED, (Object)true);
        builder.add((Object)factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.copy(), "Unknown")), ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"engraved_tablet_of_assistance")));
        registration.addRecipes(RecipeTypes.ANVIL, (List)builder.build());
        ImmutableList.Builder potionBuilder = ImmutableList.builder();
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, ModBlocks.thornveil.asItem(), ModPotions.earthly_garden));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.OCHRE_FROGLIGHT, ModPotions.bait));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.BLUE_ICE, ModPotions.frostbite));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.ECHO_SHARD, ModPotions.darkness));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.PHANTOM_MEMBRANE, ModPotions.discretion));
        potionBuilder.add((Object)new JeiBrewingRecipe((Holder<Potion>)Potions.STRONG_HEALING, ModItems.grave_dust, ModPotions.restoration));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.COBWEB, ModPotions.weaver_walk));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.RED_MUSHROOM, ModPotions.giant_strength));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.BROWN_MUSHROOM, ModPotions.little_world));
        registration.addRecipes(RecipeTypes.BREWING, (List)potionBuilder.build());
    }

    private void addCombinations(ImmutableList.Builder<CombineRecipeCategory.JeiCombineRecipe> combineBuilder, ICombineCraft iCombineCraft) {
        ItemStack combineOnStack = new ItemStack((ItemLike)iCombineCraft.asSelf());
        iCombineCraft.getCombinations().forEach(combination -> combineBuilder.add((Object)new CombineRecipeCategory.JeiCombineRecipe(combineOnStack, combination.added(), combination.result())));
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.DECORATIVE_GRAVES.values()) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)block.asItem(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_home.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_recall.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_assistance, (stack, ctx) -> ModItems.tablet_of_assistance.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_assistance.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_cupidity, (stack, ctx) -> ModItems.tablet_of_cupidity.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_cupidity.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_guard, (stack, ctx) -> ModItems.tablet_of_guard.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_guard.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        ModItems.scroll_buff.values().forEach(scroll -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, scroll, (stack, ctx) -> {
            ItemGraveMagic graveMagic = (ItemGraveMagic)stack.getItem();
            return graveMagic.isAncient((ItemStack)stack) ? "ancient" : (graveMagic.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        }));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.scroll_of_knowledge, (stack, ctx) -> ModItems.scroll_of_knowledge.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.voodoo_poppet, (stack, ctx) -> ModItems.voodoo_poppet.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.fishing_rod_of_misadventure, (stack, ctx) -> ModItems.fishing_rod_of_misadventure.isAncient((ItemStack)stack) ? "ancient" : (ModItems.fishing_rod_of_misadventure.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
    }

    private static class JeiBrewingRecipe
    implements IJeiBrewingRecipe {
        private final List<ItemStack> input;
        private final List<ItemStack> ingredient;
        private final ItemStack output;
        private final ResourceLocation rl;

        private JeiBrewingRecipe(Holder<Potion> input, Item ingredient, Holder<Potion> output) {
            this.input = Collections.singletonList(PotionContents.createItemStack((Item)Items.POTION, input));
            this.ingredient = Collections.singletonList(new ItemStack((ItemLike)ingredient));
            this.output = PotionContents.createItemStack((Item)Items.POTION, output);
            this.rl = output.unwrapKey().map(ResourceKey::location).orElse(null);
        }

        public List<ItemStack> getPotionInputs() {
            return this.input;
        }

        public List<ItemStack> getIngredients() {
            return this.ingredient;
        }

        public ItemStack getPotionOutput() {
            return this.output;
        }

        public int getBrewingSteps() {
            return 2;
        }

        public ResourceLocation getUid() {
            return this.rl;
        }
    }
}

