/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.neoforge.event.EventHooks;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;

public final class EarthlyGardenEffect
extends TombstoneEffect {
    public EarthlyGardenEffect() {
        super(MobEffectCategory.NEUTRAL, -14693540);
    }

    public boolean applyEffectTick(ServerLevel serverLevel, LivingEntity entity, int amplifier) {
        BlockPos pos = entity.blockPosition().offset((int)((Helper.RANDOM.nextGaussian() - 0.5) * 10.0), (int)((Helper.RANDOM.nextGaussian() - 0.5) * 2.0), (int)((Helper.RANDOM.nextGaussian() - 0.5) * 10.0));
        BlockState state = serverLevel.getBlockState(pos);
        if (!this.tryToPlaceRandomPlant((Level)serverLevel, pos)) {
            if (EntityHelper.isValidPlayer((Entity)entity) && EventHooks.fireBonemealEvent((Player)((Player)entity), (Level)serverLevel, (BlockPos)pos, (BlockState)state, (ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL)).isSuccessful()) {
                serverLevel.levelEvent(1505, pos, 0);
            } else {
                BonemealableBlock bonemealableBlock;
                Block block = state.getBlock();
                if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, pos, state) && bonemealableBlock.isBonemealSuccess((Level)serverLevel, Helper.RANDOM_SOURCE, pos, state)) {
                    bonemealableBlock.performBonemeal(serverLevel, Helper.RANDOM_SOURCE, pos, state);
                    serverLevel.levelEvent(1505, pos, 0);
                } else if (state.getFluidState().is((Fluid)Fluids.WATER) && BoneMealItem.growWaterPlant((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)serverLevel, (BlockPos)pos, (Direction)Direction.UP)) {
                    serverLevel.levelEvent(1505, pos.below(), 0);
                } else if (!this.tryToPlaceRandomPlant((Level)serverLevel, pos.below())) {
                    this.tryToPlaceRandomPlant((Level)serverLevel, pos.above());
                }
            }
        }
        return true;
    }

    private boolean tryToPlaceRandomPlant(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.canBeReplaced() && !state.is(BlockTags.FLOWERS) && Helper.getRandomInList(StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(state.getFluidState().is((Fluid)Fluids.WATER) ? BlockTags.UNDERWATER_BONEMEALS : BlockTags.FLOWERS).spliterator(), false).map(Holder::value).map(Block::defaultBlockState).filter(s -> s.canSurvive((LevelReader)level, pos)).collect(Collectors.toList())).map(plantState -> {
            BlockState belowState;
            boolean isLeaves = plantState.getBlock() instanceof LeavesBlock;
            if (isLeaves && (belowState = level.getBlockState(pos.below())).getCollisionShape((BlockGetter)level, pos.below()) != Shapes.block()) {
                return false;
            }
            level.setBlock(pos, isLeaves ? (BlockState)plantState.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)) : plantState, 3);
            level.levelEvent(1505, pos, 0);
            return true;
        }).orElse(false) != false;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

