/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.effect.TombstoneEffect;

public class FrostResistanceEffect
extends TombstoneEffect {
    private static final ResourceLocation SPEED_MODIFIER_POWDER_SNOW_ID = ResourceLocation.withDefaultNamespace((String)"powder_snow");

    public FrostResistanceEffect() {
        super(MobEffectCategory.BENEFICIAL, -2757129);
        this.requireSync();
    }

    public boolean applyEffectTick(ServerLevel serverLevel, LivingEntity livingEntity, int amplifier) {
        if (livingEntity.isAlive()) {
            FrostResistanceEffect.onApplyEffect(serverLevel, livingEntity, amplifier);
            return true;
        }
        return false;
    }

    public static void onApplyEffect(ServerLevel serverLevel, LivingEntity livingEntity, int amplifier) {
        if (livingEntity.getTicksFrozen() > 0) {
            livingEntity.setTicksFrozen(0);
        }
        Optional.ofNullable(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).ifPresent(movementSpeedAttribute -> movementSpeedAttribute.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID));
    }
}

