/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class FrostbiteEffect
extends TombstoneEffect {
    private static final ResourceLocation SPEED_MODIFIER_POWDER_SNOW_ID = ResourceLocation.withDefaultNamespace((String)"powder_snow");
    private static final String FROSTBITE_APPLIER = "frostbite_applier";

    public FrostbiteEffect() {
        super(MobEffectCategory.HARMFUL, -6231318);
    }

    @Override
    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        if (!livingEntity.level().isClientSide() && livingEntity.isAlive()) {
            LivingEntity livingEntity2;
            CompoundTag tag = livingEntity.getPersistentData();
            if (livingEntity.getLastHurtByMobTimestamp() == livingEntity.tickCount && (livingEntity2 = livingEntity.getLastHurtByMob()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                NBTHelper.setUUID(tag, FROSTBITE_APPLIER, serverPlayer.getUUID());
            } else {
                NBTHelper.remove(tag, FROSTBITE_APPLIER);
            }
        }
    }

    @Override
    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        CompoundTag tag;
        super.onEffectFinished(livingEntity, effectInstance);
        if (!livingEntity.level().isClientSide() && livingEntity.isAlive() && (tag = livingEntity.getPersistentData()).contains(FROSTBITE_APPLIER)) {
            NBTHelper.remove(tag, FROSTBITE_APPLIER);
        }
    }

    public boolean applyEffectTick(ServerLevel serverLevel, LivingEntity livingEntity, int amplifier) {
        if (livingEntity.isAlive()) {
            livingEntity.setTicksFrozen(Math.min(livingEntity.getTicksRequiredToFreeze(), livingEntity.getTicksFrozen() + 3));
            Optional.ofNullable(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).ifPresent(movementSpeedAttribute -> {
                movementSpeedAttribute.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
                movementSpeedAttribute.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, (double)(-0.05f * livingEntity.getPercentFrozen()), AttributeModifier.Operation.ADD_VALUE));
            });
            if (livingEntity.isFullyFrozen() && TimeHelper.atInterval(livingEntity.level(), 20)) {
                ServerPlayer player;
                MinecraftServer server;
                LivingEntity attacker = livingEntity;
                CompoundTag tag = livingEntity.getPersistentData();
                if (tag.contains(FROSTBITE_APPLIER) && (server = livingEntity.getServer()) != null && (player = (ServerPlayer)NBTHelper.getUUID(tag, FROSTBITE_APPLIER).map(uuid -> server.getPlayerList().getPlayer(uuid)).orElse(null)) != null) {
                    attacker = player;
                }
                Helper.hurtWithoutCooldown(serverLevel, livingEntity, livingEntity.damageSources().source(DamageTypes.FREEZE, (Entity)attacker), amplifier + 1);
            }
        }
        return true;
    }
}

