/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;
import ovh.corail.tombstone.effect.FrostResistanceEffect;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModTriggers;

public class GhostlyShapeEffect
extends TombstoneEffect {
    public GhostlyShapeEffect() {
        super(MobEffectCategory.NEUTRAL, -14445414);
        this.addAttributeModifier(NeoForgeMod.SWIM_SPEED, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"ghostly_shape_swim_speed"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        this.addAttributeModifier(Attributes.OXYGEN_BONUS, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"ghostly_shape_oxygen_bonus"), 5.0, AttributeModifier.Operation.ADD_VALUE);
        this.noAttributeScale();
    }

    public boolean applyEffectTick(ServerLevel serverLevel, LivingEntity livingEntity, int amplifier) {
        if (!EntityHelper.isValidPlayer((Entity)livingEntity)) {
            return false;
        }
        if ((livingEntity.horizontalCollision || livingEntity.verticalCollision) && !livingEntity.level().getEntities((Entity)livingEntity, livingEntity.getBoundingBox().inflate(0.1, 0.0, 0.1), EntityHelper::isEnemy).isEmpty()) {
            ModTriggers.cancel_ghostly_shape_by_colliding_enemy.trigger((ServerPlayer)livingEntity);
            return false;
        }
        if (TimeHelper.atInterval((Entity)livingEntity, 20)) {
            EffectHelper.clearBadEffects(livingEntity);
        }
        FrostResistanceEffect.onApplyEffect((ServerLevel)livingEntity.level(), livingEntity, amplifier);
        if (livingEntity.getHealth() < livingEntity.getMaxHealth()) {
            livingEntity.setHealth(livingEntity.getMaxHealth());
        }
        EntityHelper.resetNutrition((ServerPlayer)livingEntity);
        return true;
    }
}

