/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class MercyEffect
extends TombstoneEffect {
    private final int PROVIDED_DURATION = TimeHelper.tickFromSecond(30);

    public MercyEffect() {
        super(MobEffectCategory.NEUTRAL, -863450);
    }

    public boolean applyEffectTick(ServerLevel serverLevel, LivingEntity entity, int amplifier) {
        if (entity.isAlive()) {
            Predicate<LivingEntity> predic = EntityHelper.isValidServerPlayer((Entity)entity) ? e -> EntityHelper.isValidServerPlayer((Entity)e) || e.isAlliedTo((Entity)entity) : e -> e.isAlliedTo((Entity)entity);
            Map<Holder, MobEffectInstance> effects = entity.getActiveEffectsMap().entrySet().stream().filter(e -> EffectHelper.isBeneficial((MobEffect)((Holder)e.getKey()).value()) && ((MobEffectInstance)e.getValue()).getDuration() >= 1200).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<LivingEntity> entities = serverLevel.getEntities((Entity)entity, entity.getBoundingBox().inflate(5.0, 3.0, 5.0), e -> {
                LivingEntity living;
                return e instanceof LivingEntity && (living = (LivingEntity)e).isAlive() && predic.test(living);
            }).stream().map(LivingEntity.class::cast).toList();
            for (Map.Entry<Holder, MobEffectInstance> entry : effects.entrySet()) {
                int effectAmplifier = entry.getValue().getAmplifier();
                List<LivingEntity> validEntities = entities.stream().filter(e -> e.canBeAffected((MobEffectInstance)entry.getValue())).filter(e -> {
                    MobEffectInstance effect = e.getEffect((Holder)entry.getKey());
                    return effect == null || effect.getAmplifier() < effectAmplifier;
                }).toList();
                int maxEntities = Math.min(validEntities.size(), (entry.getValue().getDuration() - this.PROVIDED_DURATION) / this.PROVIDED_DURATION);
                if (maxEntities <= 0) continue;
                EffectHelper.capDuration(entity, (Holder<MobEffect>)entry.getKey(), entry.getValue().getDuration() - maxEntities * this.PROVIDED_DURATION);
                validEntities.stream().limit(maxEntities).forEach(e -> e.addEffect(new MobEffectInstance((Holder)entry.getKey(), this.PROVIDED_DURATION, effectAmplifier)));
            }
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 100 == 0;
    }
}

