/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;

public record ApplyBoneShieldEffect(LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyBoneShieldEffect> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyBoneShieldEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyBoneShieldEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyBoneShieldEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyBoneShieldEffect::maxAmplifier)).apply((Applicative)c, ApplyBoneShieldEffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse itemInUse, Entity entity, Vec3 origin) {
        Holder<MobEffect> effectHolder;
        LivingEntity target;
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).isAlive() && (effectHolder = ModEffects.bone_shield) != null) {
            int duration = Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minDuration.calculate(enchantmentLevel), (float)this.maxDuration.calculate(enchantmentLevel)) * 20.0f);
            int amplifier = Math.max(0, Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minAmplifier.calculate(enchantmentLevel), (float)this.maxAmplifier.calculate(enchantmentLevel))));
            int oldDuration = EffectHelper.getDuration(target, effectHolder, amplifier);
            if (oldDuration >= 0) {
                MobEffectInstance effectInstance = new MobEffectInstance(effectHolder, Mth.clamp((int)(duration + oldDuration), (int)-1, (int)Integer.MAX_VALUE), amplifier);
                target.addEffect(effectInstance);
            }
        }
    }

    public MapCodec<ApplyBoneShieldEffect> codec() {
        return CODEC;
    }
}

