/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.Trades;
import ovh.corail.tombstone.entity.ai.LookAtTradingPlayerGoal;
import ovh.corail.tombstone.entity.ai.TradeWithPlayerGoal;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public abstract class AbstractMerchant
extends PathfinderMob
implements Merchant {
    private static final EntityDataAccessor<Byte> TRADE_LEVEL = SynchedEntityData.defineId(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> TRADE_XP = SynchedEntityData.defineId(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    protected Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    protected long lastRestockGameTime = -1L;
    private static final int UPDATE_VERSION = 9;

    protected AbstractMerchant(EntityType<? extends AbstractMerchant> merchant, Level level) {
        super(merchant, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRADE_LEVEL, (Object)1);
        builder.define(TRADE_XP, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new TradeWithPlayerGoal<AbstractMerchant>(this));
        this.goalSelector.addGoal(1, new LookAtTradingPlayerGoal<AbstractMerchant>(this));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.initTrades();
        }
        return this.offers;
    }

    private void initTrades() {
        this.offers = new MerchantOffers();
        int tradeLevel = this.getTradeLevel();
        this.addBasicTrades(TradeType.COMMON, tradeLevel + 4);
        if (tradeLevel > 1) {
            this.addBasicTrades(TradeType.UNCOMMON, tradeLevel + 2);
        }
        if (tradeLevel > 3) {
            this.addBasicTrades(TradeType.RARE, tradeLevel);
        }
        if (TimeHelper.isDateAroundHalloween()) {
            this.addHalloweenTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addHalloweenTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addHalloweenTrades(TradeType.RARE);
            }
        } else if (TimeHelper.isDateAroundChristmas()) {
            this.addChristmasTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addChristmasTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addChristmasTrades(TradeType.RARE);
            }
        } else if (TimeHelper.isDateAroundSpringBloom()) {
            this.addSpringBloomTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addSpringBloomTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addSpringBloomTrades(TradeType.RARE);
            }
        }
        EventFactory.onInitGraveGuardianOffers(this);
    }

    private void addBasicTrades(TradeType tradeType, int toAdd) {
        Optional.of(tradeType.getBasicTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, toAdd));
    }

    private void addHalloweenTrades(TradeType tradeType) {
        Optional.of(tradeType.getHalloweenTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addChristmasTrades(TradeType tradeType) {
        Optional.of(tradeType.getChristmasTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addSpringBloomTrades(TradeType tradeType) {
        Optional.of(tradeType.getSpringBloomTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addTrades(VillagerTrades.ItemListing[] trades, int toAdd) {
        if (toAdd >= trades.length) {
            Arrays.stream(trades).map(trade -> trade.getOffer((Entity)this, this.random)).filter(Objects::nonNull).forEach(arg_0 -> this.getOffers().add(arg_0));
        } else {
            List ids = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
            Collections.shuffle(ids, Helper.RANDOM);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                MerchantOffer offer = trades[id].getOffer((Entity)this, this.random);
                if (offer == null) continue;
                this.getOffers().add((Object)offer);
                if (--toAdd > 0) continue;
                break;
            }
        }
    }

    public void overrideOffers(MerchantOffers offers) {
        this.offers = offers;
    }

    public void overrideXp(int xp) {
        this.setVillagerXp(xp);
        this.increaseLevel(0);
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.playSound(stack.isEmpty() ? SoundEvents.SKELETON_SHOOT : SoundEvents.SKELETON_STEP, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        if (EntityHelper.isValidServerPlayer((Entity)this.tradingPlayer)) {
            ServerPlayer player = (ServerPlayer)this.tradingPlayer;
            ModTriggers.trade_grave_guardian.trigger(player);
            if (TimeHelper.isDateAroundSpringBloom()) {
                if (offer.getBaseCostA().is(ModBlocks.thornveil.asItem()) || offer.getCostB().is(ModBlocks.thornveil.asItem())) {
                    ModTriggers.trade_flower.trigger(player);
                }
                if (offer.getResult().is((Item)ModItems.essence_of_undeath)) {
                    ModTriggers.get_essence_from_thornveil.trigger(player);
                }
            } else {
                boolean isFirstSlot = offer.getBaseCostA().is((Item)ModItems.lollipop);
                if (isFirstSlot || offer.getCostB().is((Item)ModItems.lollipop)) {
                    ModTriggers.trade_lollipop.trigger(player, (isFirstSlot ? offer.getBaseCostA() : offer.getCostB()).getCount());
                    if (offer.getResult().is((Item)ModItems.essence_of_undeath)) {
                        ModTriggers.trade_lollipop_for_essence.trigger(player);
                    }
                }
            }
        }
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        boolean isLevelUp = this.increaseLevel(offer.getXp());
        if (offer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), (isLevelUp ? 20 : 0) + this.random.nextInt(offer.getXp()) + offer.getXp()));
        }
    }

    private boolean increaseLevel(int offerXp) {
        int traderLevel = this.getTradeLevel();
        this.setVillagerXp(this.getVillagerXp() + offerXp);
        if (traderLevel < 5 && this.getVillagerXp() >= VillagerData.getMaxXpPerLevel((int)traderLevel)) {
            this.setTradeLevel(traderLevel + 1);
            this.initTrades();
            Optional.ofNullable(this.getTradingPlayer()).ifPresent(player -> player.sendMerchantOffers(player.containerMenu.containerId, this.getOffers(), traderLevel + 1, this.getVillagerXp(), this.showProgressBar(), this.canRestock()));
            return true;
        }
        return false;
    }

    @Nullable
    public Entity teleport(TeleportTransition dimensionTransition) {
        this.setTradingPlayer(null);
        return super.teleport(dimensionTransition);
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.setTradingPlayer(null);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && this.tradingPlayer == null) {
            if (hand == InteractionHand.MAIN_HAND && EntityHelper.isValidServerPlayer((Entity)player)) {
                ModTriggers.talk_grave_guardian.trigger((ServerPlayer)player);
            }
            if (!(this.level().isClientSide || this.getOffers().isEmpty() || EntityHelper.targetAnEnemy((LivingEntity)this))) {
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), this.getTradeLevel());
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public int getVillagerXp() {
        return (Integer)this.entityData.get(TRADE_XP);
    }

    public void setVillagerXp(int tradeXp) {
        this.entityData.set(TRADE_XP, (Object)tradeXp);
    }

    public int getTradeLevel() {
        return (Byte)this.entityData.get(TRADE_LEVEL) & 0xFF;
    }

    public void setTradeLevel(int tradeLevel) {
        this.entityData.set(TRADE_LEVEL, (Object)((byte)tradeLevel));
    }

    public boolean showProgressBar() {
        return true;
    }

    public boolean canRestock() {
        return true;
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    public void restock() {
        for (MerchantOffer offer : this.getOffers()) {
            boolean hasBoneNeedleA = offer.getBaseCostA().is((Item)ModItems.bone_needle);
            boolean hasBoneNeedleB = offer.getCostB().is((Item)ModItems.bone_needle);
            if ((hasBoneNeedleA || hasBoneNeedleB) && (offer.getUses() > 0 || this.random.nextInt(31) == 0)) {
                if (hasBoneNeedleA) {
                    ModItems.bone_needle.withRandomImpregnation(offer.getBaseCostA());
                }
                if (hasBoneNeedleB) {
                    ModItems.bone_needle.withRandomImpregnation(offer.getCostB());
                }
            }
            if (offer.getBaseCostA().is((Item)ModItems.lollipop) && this.random.nextInt(31) == 0) {
                ModItems.lollipop.resetColor(offer.getBaseCostA());
            }
            if (offer.getResult().is((Item)ModItems.receptacle_of_familiar) && ModItems.receptacle_of_familiar.containSoul(offer.getResult()) && this.random.nextInt(31) == 0) {
                ModItems.receptacle_of_familiar.setRandomFamiliar(offer.getResult());
            }
            offer.resetUses();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.tradingPlayer == null && this.canRestock()) {
            long serverGlobalTime = GlobalClock.INSTANCE.getTime(this.level());
            if (this.lastRestockGameTime <= 0L || this.lastRestockGameTime > serverGlobalTime) {
                this.lastRestockGameTime = serverGlobalTime;
            } else if (TimeHelper.minuteElapsed(serverGlobalTime, this.lastRestockGameTime) >= (long)Math.max(1, (Integer)ConfigTombstone.decorative_grave.restockTimeGraveGuardian.get())) {
                this.lastRestockGameTime = serverGlobalTime;
                this.restock();
            }
        }
    }

    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.SKELETON_CONVERTED_TO_STRAY;
    }

    public boolean stillValid(Player player) {
        return this.getTradingPlayer() == player && this.isAlive() && player.canInteractWithEntity((Entity)this, 4.0);
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        SerializationHelper.setShort(valueOutput, "special_event", (short)TimeHelper.getSpecialEvent().ordinal());
        SerializationHelper.setShort(valueOutput, "update_version", (short)9);
        MerchantOffers offers = this.getOffers();
        if (!offers.isEmpty()) {
            valueOutput.store("Offers", MerchantOffers.CODEC, (Object)offers);
        }
        SerializationHelper.setByte(valueOutput, "trade_level", (Byte)this.entityData.get(TRADE_LEVEL));
        SerializationHelper.setInt(valueOutput, "trade_xp", this.getVillagerXp());
        SerializationHelper.setLong(valueOutput, "last_restock", this.lastRestockGameTime);
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.loadOffers(valueInput);
        this.setTradeLevel(SerializationHelper.getByte(valueInput, "trade_level"));
        this.setVillagerXp(SerializationHelper.getInt(valueInput, "trade_xp"));
        this.lastRestockGameTime = SerializationHelper.getLong(valueInput, "last_restock");
    }

    private boolean specialEventRequireChangeTrade(ValueInput valueInput) {
        return SerializationHelper.getOptionalShort(valueInput, "special_event").filter(id -> TimeHelper.getSpecialEvent().ordinal() != id.shortValue()).isPresent();
    }

    private void loadOffers(ValueInput valueInput) {
        if (this.specialEventRequireChangeTrade(valueInput)) {
            this.offers = null;
        } else if (9 != SerializationHelper.getShort(valueInput, "update_version")) {
            this.offers = null;
        } else {
            this.offers = valueInput.read("Offers", MerchantOffers.CODEC).orElse(null);
            if (this.offers == null) {
                return;
            }
            for (MerchantOffer offer : this.offers) {
                IDisableable disableable;
                ItemStack buy2;
                Item item;
                IDisableable disableable2;
                ItemStack buy1 = offer.getBaseCostA();
                Item item2 = buy1.getItem();
                if (item2 instanceof IDisableable && !(disableable2 = (IDisableable)item2).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (buy1.is((Item)ModItems.bone_needle) && ModItems.bone_needle.getEntityType(buy1).isEmpty()) {
                    ModItems.bone_needle.withRandomImpregnation(buy1);
                }
                if ((item = (buy2 = offer.getCostB()).getItem()) instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (!buy2.is((Item)ModItems.bone_needle) || !ModItems.bone_needle.getEntityType(buy2).isEmpty()) continue;
                ModItems.bone_needle.withRandomImpregnation(buy2);
            }
        }
    }

    private static enum TradeType {
        COMMON,
        UNCOMMON,
        RARE;


        private VillagerTrades.ItemListing[] getBasicTrades() {
            return (VillagerTrades.ItemListing[])Trades.TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getHalloweenTrades() {
            return (VillagerTrades.ItemListing[])Trades.HALLOWEEN_TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getChristmasTrades() {
            return (VillagerTrades.ItemListing[])Trades.CHRISTMAS_TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getSpringBloomTrades() {
            return (VillagerTrades.ItemListing[])Trades.SPRING_BLOOM_TRADES.get(this.ordinal() + 1);
        }
    }
}

