/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidType;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.SerializationHelper;

public final class Cloud
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(Cloud.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int lifetime = 6000;

    public Cloud(EntityType<Cloud> cloudType, Level level) {
        super(cloudType, level);
        this.noPhysics = true;
        this.setInvisible(true);
        this.setInvulnerable(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_COLOR, (Object)0xFFFFFF);
    }

    public int getColor() {
        return (Integer)this.entityData.get(DATA_COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(DATA_COLOR, (Object)color);
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void tick() {
        if (this.level().isClientSide) {
            ProxyHelper.produceGraveSmoke(this.level(), 2, this.getX(), this.getY() + 0.4, this.getZ(), this.getColor());
        } else if (this.tickCount >= this.lifetime) {
            this.discard();
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float amount) {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean canTeleport(Level fromLevel, Level toLevel) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean shouldShowName() {
        return false;
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.tickCount = SerializationHelper.getInt(valueInput, "tick_count");
        this.setColor(SerializationHelper.getInt(valueInput, "color"));
        this.setLifetime(SerializationHelper.getInt(valueInput, "lifetime"));
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        SerializationHelper.setInt(valueOutput, "tick_count", this.tickCount);
        SerializationHelper.setInt(valueOutput, "color", this.getColor());
        SerializationHelper.setInt(valueOutput, "lifetime", this.lifetime);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }
}

