/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.AbstractMerchant;
import ovh.corail.tombstone.entity.ai.StayNearHome;
import ovh.corail.tombstone.entity.ai.spell.CurseSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellCastingGoal;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;

public final class GraveGuardian
extends AbstractMerchant
implements RangedAttackMob {
    @Nullable
    private GlobalPos homePos = null;
    public float oBob;
    public float bob;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;

    public GraveGuardian(EntityType<? extends GraveGuardian> graveGuardianEntityType, Level level) {
        super(graveGuardianEntityType, level);
        this.setCanPickUpLoot(false);
        this.getNavigation().setCanFloat(true);
    }

    public static AttributeSupplier createAttributes() {
        AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.ARMOR, 2.0).add(Attributes.ARMOR_TOUGHNESS, 1.0).add(Attributes.SCALE, 1.2);
        builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder.build();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(4, new StayNearHome<GraveGuardian>(this, GraveGuardian::getHomePos, GraveGuardian::resetHomePos, 0.8));
        this.goalSelector.addGoal(1, (Goal)new SpellCastingGoal(this));
        this.goalSelector.addGoal(3, (Goal)new CurseSpellGoal(this, new MobEffectInstance(ModEffects.frostbite, 200, 5)));
        this.goalSelector.addGoal(4, (Goal)new CurseSpellGoal(this, new MobEffectInstance(MobEffects.DARKNESS, 200, 5)));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, (entity, serverLevel) -> EntityHelper.isEnemy((Entity)entity)));
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).is(BlockTags.SOUL_SPEED_BLOCKS) ? 5.0f : 0.0f;
    }

    public GlobalPos getHomePos() {
        if (this.homePos == null) {
            this.resetHomePos();
        }
        return this.homePos;
    }

    public void resetHomePos() {
        @Nullable BlockPos nearestGravePos = new CopyOnWriteArrayList(this.level().blockEntityTickers).stream().filter(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).ticker).blockEntity;
                return ModBlocks.isDecorativeGrave(blockEntity.getBlockState().getBlock());
            }
            catch (Throwable throwable) {
                return false;
            }
        }).map(TickingBlockEntity::getPos).min(Comparator.comparingInt(a -> this.blockPosition().distManhattan((Vec3i)a))).orElse(null);
        this.homePos = GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)Optional.ofNullable(nearestGravePos).filter(pos -> (double)this.blockPosition().distManhattan((Vec3i)pos) < 500.0).orElse(this.blockPosition()));
    }

    public void checkDespawn() {
        if (!((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue()) {
            super.checkDespawn();
        }
    }

    public boolean isPersistenceRequired() {
        return (Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get();
    }

    public boolean removeWhenFarAway(double distance) {
        return (Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get() == false;
    }

    public boolean canTeleport(Level fromLevel, Level toLevel) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean canFreeze() {
        return false;
    }

    public void performRangedAttack(LivingEntity entity, float distance) {
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.STRAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.STRAY_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.STRAY_STEP, 0.15f, 1.0f);
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    public boolean causeFallDamage(double distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean p_34176_) {
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, EntitySpawnReason spawnType, @Nullable SpawnGroupData groupData) {
        ProtectedEntityHandler.apply((LivingEntity)this, true);
        this.populateDefaultEquipmentSlots(Helper.RANDOM_SOURCE, difficultyInstance);
        return groupData;
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        ItemStack weapon = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        ItemEnchantments.Mutable weaponEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        ModEnchantments.getEnchantmentHolder(ModEnchantments.magic_siphon, this.level()).ifPresent(ench -> weaponEnchantments.set(ench, 5));
        ModEnchantments.getEnchantmentHolder(ModEnchantments.plague_bringer, this.level()).ifPresent(ench -> weaponEnchantments.set(ench, 5));
        ModEnchantments.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.UNBREAKING, this.level()).ifPresent(ench -> weaponEnchantments.set(ench, 5));
        EnchantmentHelper.setEnchantments((ItemStack)weapon, (ItemEnchantments)weaponEnchantments.toImmutable());
        this.setItemSlot(EquipmentSlot.MAINHAND, weapon);
        ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        ModEnchantments.getEnchantmentHolder(ModEnchantments.blessing, this.level()).ifPresent(ench -> itemEnchantments.set(ench, 5));
        ModEnchantments.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.UNBREAKING, this.level()).ifPresent(ench -> itemEnchantments.set(ench, 5));
        ItemStack head = new ItemStack((ItemLike)Items.NETHERITE_HELMET);
        ItemStack chest = new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE);
        ItemStack leggings = new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS);
        EnchantmentHelper.setEnchantments((ItemStack)head, (ItemEnchantments)itemEnchantments.toImmutable());
        EnchantmentHelper.setEnchantments((ItemStack)chest, (ItemEnchantments)itemEnchantments.toImmutable());
        EnchantmentHelper.setEnchantments((ItemStack)leggings, (ItemEnchantments)itemEnchantments.toImmutable());
        this.setItemSlot(EquipmentSlot.HEAD, head);
        this.setItemSlot(EquipmentSlot.CHEST, chest);
        this.setItemSlot(EquipmentSlot.LEGS, leggings);
        ItemStack boots = new ItemStack((ItemLike)Items.NETHERITE_BOOTS);
        ModEnchantments.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SOUL_SPEED, this.level()).ifPresent(ench -> itemEnchantments.set(ench, 3));
        EnchantmentHelper.setEnchantments((ItemStack)boots, (ItemEnchantments)itemEnchantments.toImmutable());
        this.setItemSlot(EquipmentSlot.FEET, boots);
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return super.canBeAffected(effectInstance) && !EffectHelper.isHarmful((MobEffect)effectInstance.getEffect().value());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.isAlive() && TimeHelper.atInterval(this.level(), 20)) {
                this.heal(5.0f);
            }
        } else {
            this.moveCloak();
        }
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.getX() - this.xCloak;
        double d1 = this.getY() - this.yCloak;
        double d2 = this.getZ() - this.zCloak;
        double limit = 10.0;
        if (d0 > limit) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 > limit) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 > limit) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if (d0 < -limit) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 < -limit) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 < -limit) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    @Override
    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        if (this.homePos != null) {
            SerializationHelper.setLocation(valueOutput, "home_position", new Location(this.homePos));
        }
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.homePos = SerializationHelper.getLocation(valueInput, "home_position").map(Location::asGlobalPos).orElse(null);
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public void aiStep() {
        this.updateSwingTime();
        this.oBob = this.bob;
        super.aiStep();
        float f = this.onGround() && !this.isDeadOrDying() && !this.isSwimming() ? Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance()) : 0.0f;
        this.bob += (f - this.bob) * 0.4f;
    }
}

