/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.entity.ai.StayNearHome;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SerializationHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class SpectralWolf
extends Animal {
    @Nullable
    private GlobalPos homePos = null;
    @Nullable
    private UUID ownerId = null;
    private int lifetime = 12000;

    public SpectralWolf(EntityType<? extends SpectralWolf> entityType, Level level) {
        super(entityType, level);
        this.setCanPickUpLoot(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, new StayNearHome<SpectralWolf>(this, SpectralWolf::getHomePos, SpectralWolf::resetHomePos, 0.8));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.ownerId != null) {
            this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((Mob)this){

                @Override
                protected Optional<Player> getOwner() {
                    return SpectralWolf.this.getOwner();
                }
            });
            this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((Mob)this){

                @Override
                protected Optional<Player> getOwner() {
                    return SpectralWolf.this.getOwner();
                }
            });
        } else {
            this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        }
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, (entity, serverLevel) -> EntityHelper.isEnemy((Entity)entity)));
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        SerializationHelper.setInt(valueOutput, "lifetime", this.lifetime);
        if (this.homePos != null) {
            SerializationHelper.setLocation(valueOutput, "home_position", new Location(this.homePos));
        }
        SerializationHelper.setUUID(valueOutput, "owner_id", this.ownerId);
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setLifetime(SerializationHelper.getInt(valueInput, "lifetime"));
        this.homePos = SerializationHelper.getLocation(valueInput, "home_position").map(Location::asGlobalPos).orElse(null);
        this.ownerId = SerializationHelper.getUUID(valueInput, "owner_id").orElse(null);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.isAlive() && TimeHelper.atInterval(this.level(), 20)) {
                this.heal(1.0f);
            }
            if (this.tickCount >= this.lifetime) {
                this.discard();
            }
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).is(BlockTags.SOUL_SPEED_BLOCKS) ? 5.0f : 0.0f;
    }

    public GlobalPos getHomePos() {
        if (this.homePos == null) {
            this.resetHomePos();
        }
        return this.homePos;
    }

    public void resetHomePos() {
        this.homePos = GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.blockPosition());
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void increaseLifetime(int amount) {
        this.setLifetime(this.lifetime + amount);
        this.setHealth(this.getMaxHealth());
    }

    public void setOwner(@Nullable Player owner) {
        this.ownerId = Optional.ofNullable(owner).map(Player::getGameProfile).map(GameProfile::getId).orElse(null);
    }

    public Optional<Player> getOwner() {
        return Optional.ofNullable(this.ownerId).map(ownerId -> this.level().getPlayerByUUID(ownerId));
    }

    public boolean isOwner(Player owner) {
        return this.ownerId != null && this.ownerId.equals(owner.getGameProfile().getId());
    }

    public void checkDespawn() {
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public boolean isFood(ItemStack p_27600_) {
        return false;
    }

    public boolean canTeleport(Level fromLevel, Level toLevel) {
        return false;
    }

    public boolean canFreeze() {
        return false;
    }

    public boolean causeFallDamage(double distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean p_34176_) {
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return super.canBeAffected(effectInstance) && !EffectHelper.isHarmful((MobEffect)effectInstance.getEffect().value());
    }

    public boolean isInvisibleTo(Player player) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public float getTailAngle() {
        return 1.5393804f;
    }

    public boolean canMate(Animal animal) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.GRUMPY)).growlSound().value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.GRUMPY)).hurtSound().value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.GRUMPY)).deathSound().value();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public static AttributeSupplier buildAttributes() {
        AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 2.0).add(Attributes.SCALE, 1.3);
        builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder.build();
    }
}

