/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

public class Trades {
    static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.BONE, 10), r -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.ROTTEN_FLESH, 10), r -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.GUNPOWDER, 3), r -> new ItemStack((ItemLike)ModItems.dust_of_vanishing), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.SNOWBALL, 3), r -> new ItemStack((ItemLike)ModItems.dust_of_frost), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.BUNDLE), r -> new ItemStack((ItemLike)ModItems.grave_dust, 3), 1, 3), new TradeForItems(() -> new ItemStack((ItemLike)Items.BLUE_ICE), r -> EffectHelper.createMagicArrows(16, ModEffects.frostbite), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.RABBIT_FOOT), r -> new ItemStack((ItemLike)ModItems.seeker_rod), 1, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.OCHRE_FROGLIGHT), r -> EffectHelper.createMagicArrows(16, (Holder<MobEffect>)MobEffects.DARKNESS), 5, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.dark_marble_stairs, 20), r -> new ItemStack((ItemLike)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.bone_needle.withRandomImpregnation(new ItemStack((ItemLike)ModItems.bone_needle)), r -> new ItemStack((ItemLike)ModItems.grave_dust, 5), 1, 5), new TradeForItems(() -> ModItems.bone_needle.withRandomImpregnation(new ItemStack((ItemLike)ModItems.bone_needle)), r -> new ItemStack((ItemLike)ModItems.grave_dust, 5), 1, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL), r -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(false).orElse(new ItemStack((ItemLike)Items.GOLDEN_APPLE)), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.SKELETON_SKULL), r -> ModItems.magic_scroll.setRandomMagicEffect(new ItemStack((ItemLike)ModItems.magic_scroll)), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.PEARLESCENT_FROGLIGHT), r -> EffectHelper.createMagicArrows(16, ModEffects.bait), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE), r -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.discretion), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModItems.grave_dust, 10), r -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.restoration), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR), r -> new ItemStack((ItemLike)ModItems.gemstone_of_familiar), 1, 10)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.green_marble_slab, 64), r -> ModItems.tablet_of_recall.createAncient(), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.blue_marble_slab, 64), r -> ModItems.tablet_of_home.createAncient(), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)Items.GHAST_TEAR, 5), r -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(true).orElse(new ItemStack((ItemLike)Items.DRAGON_HEAD)), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.BLAZE_POWDER, 3), r -> ModItems.magic_scroll.createAncient(), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.VERDANT_FROGLIGHT), r -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.earthly_garden), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.carmin_marble_wall, 64), r -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 15), new TradeForItems(() -> new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 10), r -> new ItemStack((ItemLike)ModItems.receptacle_of_soul), 1, 15), new TradeForItems(() -> new ItemStack((ItemLike)Items.AXOLOTL_BUCKET), r -> {
        ItemStack stack = new ItemStack((ItemLike)ModItems.fishing_rod_of_misadventure);
        stack.set(ModDataComponents.ENCHANTED, (Object)true);
        return ModItems.fishing_rod_of_misadventure.setAncient(stack);
    }, 1, 10), new TradeForItems(() -> {
        ItemStack familiarReceptacle = new ItemStack((ItemLike)ModItems.receptacle_of_familiar);
        familiarReceptacle.set(ModDataComponents.ENTITY_TYPE, (Object)(Helper.RANDOM.nextBoolean() ? "minecraft:skeleton_horse" : "minecraft:zombie_horse"));
        familiarReceptacle.set(ModDataComponents.IS_LOOT_NO_SYNC, (Object)true);
        return familiarReceptacle;
    }, r -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 20), new TradeForItems(() -> new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE), r -> EffectHelper.createCursedArrows(16), 3, 10)}));
    static final Int2ObjectMap<VillagerTrades.ItemListing[]> HALLOWEEN_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(), r -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(), r -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(false).orElse(new ItemStack((ItemLike)Items.DRAGON_BREATH)), 5, 1), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(), r -> ModItems.magic_scroll.setRandomMagicEffect(new ItemStack((ItemLike)ModItems.magic_scroll)), 5, 1), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(3), r -> EffectHelper.createMagicArrows(16, ModEffects.frostbite, 2), 5, 3)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(5), r -> new ItemStack((ItemLike)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(5), r -> ModItems.magic_scroll.createAncient(), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(10), r -> ModItems.voodoo_poppet.createEnchantedStack(), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(5), r -> EffectHelper.createMagicArrows(16, ModEffects.frostbite, 4), 5, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(64), r -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 15), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(20), r -> new ItemStack((ItemLike)ModItems.receptacle_of_soul), 1, 10), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(10), r -> Helper.createEnchantedBook(r, ModEnchantments.frostbite, 5), 1, 5)}));
    static final Int2ObjectMap<VillagerTrades.ItemListing[]> CHRISTMAS_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.PAPER, 10), r -> ModItems.lollipop.getRandomItemStack(), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.BAMBOO, 10), r -> ModItems.lollipop.getRandomItemStack(), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.COAL, 10), r -> ModItems.lollipop.getRandomItemStack(), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.PAPER), () -> new ItemStack((ItemLike)Items.INK_SAC), r -> new ItemStack((ItemLike)ModItems.villager_gift), 1, 0)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.BUNDLE), r -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(false).orElse(new ItemStack((ItemLike)Items.GOLDEN_APPLE)), 5, 3), new TradeForItems(() -> ModItems.lollipop.getRandomItemStack(5), r -> ModItems.magic_scroll.createAncient(), 5, 3), new TradeForItems(() -> new ItemStack((ItemLike)Items.SNOWBALL, 64), r -> new ItemStack((ItemLike)ModItems.gemstone_of_prayer), 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.CRAFTING_TABLE, 30), r -> new ItemStack((ItemLike)ModItems.receptacle_of_soul), 1, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.CRAFTING_TABLE, 64), r -> Helper.createEnchantedBook(r, ModEnchantments.frostbite, 10), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModItems.essence_of_undeath), r -> new ItemStack((ItemLike)ModItems.christmas_hat), 1, 10)}));
    static final Int2ObjectMap<VillagerTrades.ItemListing[]> SPRING_BLOOM_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil), r -> new ItemStack((ItemLike)ModItems.grave_dust, 2), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.DANDELION, 5), r -> ItemScrollBuff.SpellBuff.FEATHER_FALL.getEnchantedStack(), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.BONE_MEAL, 8), r -> new ItemStack((ItemLike)ModItems.bag_of_seeds), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.CORNFLOWER, 5), r -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(false).orElse(new ItemStack((ItemLike)Items.GOLDEN_APPLE)), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.LILY_OF_THE_VALLEY, 5), r -> ModItems.magic_scroll.setRandomMagicEffect(new ItemStack((ItemLike)ModItems.magic_scroll)), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.POPPY, 5), r -> ItemScrollBuff.SpellBuff.PURIFICATION.getEnchantedStack(), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil), () -> new ItemStack((ItemLike)ModItems.strange_scroll), r -> ItemScrollBuff.SpellBuff.PRESERVATION.getAncientStack(), 5, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil, 2), () -> new ItemStack((ItemLike)Items.GLOW_BERRIES, 10), r -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.restoration), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil, 2), () -> new ItemStack((ItemLike)Blocks.SOUL_SOIL, 2), r -> new ItemStack((ItemLike)ModItems.gemstone_of_prayer), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil), () -> new ItemStack((ItemLike)Items.BOOK), r -> new ItemStack((ItemLike)ModItems.book_of_repairing), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil), () -> new ItemStack((ItemLike)Items.SUNFLOWER), r -> new ItemStack((ItemLike)ModItems.book_of_scribe), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil), r -> PotionContents.createItemStack((Item)Items.POTION, ModPotions.earthly_garden), 3, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil, 5), () -> new ItemStack((ItemLike)Blocks.SOUL_SOIL, 2), r -> new ItemStack((ItemLike)ModItems.gemstone_of_familiar), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil, 5), () -> new ItemStack((ItemLike)Items.DIAMOND, 2), r -> ModItems.receptacle_of_familiar.setRandomFamiliar(new ItemStack((ItemLike)ModItems.receptacle_of_familiar)), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModBlocks.thornveil, 20), () -> new ItemStack((ItemLike)Items.SOUL_SOIL, 10), r -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 10)}));

    private static class TradeForItems
    implements VillagerTrades.ItemListing {
        private final TradeIngredient requestItem1;
        private final TradeIngredient requestItem2;
        private final Function<RegistryAccess, ItemStack> rewardItem;
        private final int maxUses;
        private final int villagerXp;

        private TradeForItems(Supplier<ItemStack> requestItem, Function<RegistryAccess, ItemStack> rewardItem, int maxUses, int villagerXp) {
            this(new TradeIngredient(requestItem), TradeIngredient.EMPTY, rewardItem, maxUses, villagerXp);
        }

        private TradeForItems(Supplier<ItemStack> requestItem1, Supplier<ItemStack> requestItem2, Function<RegistryAccess, ItemStack> rewardItem, int maxUses, int villagerXp) {
            this(new TradeIngredient(requestItem1), new TradeIngredient(requestItem2), rewardItem, maxUses, villagerXp);
        }

        private TradeForItems(TradeIngredient requestItem, Function<RegistryAccess, ItemStack> rewardItem, int maxUses, int villagerXp) {
            this(requestItem, TradeIngredient.EMPTY, rewardItem, maxUses, villagerXp);
        }

        private TradeForItems(TradeIngredient requestItem1, TradeIngredient requestItem2, Function<RegistryAccess, ItemStack> rewardItem, int maxUses, int villagerXp) {
            this.requestItem1 = requestItem1;
            this.requestItem2 = requestItem2;
            this.rewardItem = rewardItem;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource randomSource) {
            return new MerchantOffer(this.requestItem1.asItemCost(), Optional.of(this.requestItem2.asItemCost()).filter(itemCost -> !itemCost.itemStack().isEmpty()), this.rewardItem.apply(entity.level().registryAccess()), 0, this.maxUses, this.villagerXp, 0.0f, 0);
        }
    }

    private static class TradeIngredient {
        private final Supplier<ItemStack> stackSupplier;
        private final DataComponentExactPredicate componentPredicate;
        private static final TradeIngredient EMPTY = new TradeIngredient(() -> ItemStack.EMPTY);

        private TradeIngredient(Supplier<ItemStack> stackSupplier) {
            this(stackSupplier, DataComponentExactPredicate.EMPTY);
        }

        private TradeIngredient(Supplier<ItemStack> stackSupplier, DataComponentExactPredicate componentPredicate) {
            this.stackSupplier = stackSupplier;
            this.componentPredicate = componentPredicate;
        }

        private ItemCost asItemCost() {
            ItemStack stack = this.stackSupplier.get();
            return new ItemCost((Holder)stack.getItem().builtInRegistryHolder(), stack.getCount(), this.componentPredicate, stack);
        }
    }
}

