/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.helper.Helper;

public class BuffOtherSpellGoal
extends SpellUseGoal {
    protected final MobEffectInstance mobEffectInstance;
    protected final TargetingConditions buffTargeting;

    public BuffOtherSpellGoal(PathfinderMob caster, MobEffectInstance mobEffectInstance) {
        super(caster);
        this.mobEffectInstance = mobEffectInstance;
        this.buffTargeting = TargetingConditions.forNonCombat().range(16.0).selector((e, serverLevel) -> e.isAlive() && this.caster.isAlliedTo((Entity)e) && !e.hasEffect(this.mobEffectInstance.getEffect()));
    }

    @Override
    public boolean canUse() {
        List entitiesToHeal;
        if (super.canUse() && !(entitiesToHeal = ((ServerLevel)this.caster.level()).getNearbyEntities(LivingEntity.class, this.buffTargeting, (LivingEntity)this.caster, this.caster.getBoundingBox().inflate(16.0, 4.0, 16.0))).isEmpty()) {
            SpellCasterHandler.setSpecialTarget((LivingEntity)this.caster, (LivingEntity)entitiesToHeal.get(Helper.RANDOM.nextInt(entitiesToHeal.size())));
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).map(e -> !e.hasEffect(this.mobEffectInstance.getEffect())).orElse(false) != false;
    }

    @Override
    protected void performSpellCasting() {
        SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).ifPresent(entity -> entity.addEffect(new MobEffectInstance(this.mobEffectInstance)));
    }

    @Override
    protected int getCastWarmupTime() {
        return 10;
    }

    @Override
    protected int getCastingTime() {
        return 20;
    }

    @Override
    protected int getCastingInterval() {
        return 300;
    }

    @Override
    @Nullable
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.ILLUSIONER_PREPARE_MIRROR;
    }

    @Override
    protected int getSpellColor() {
        return ((MobEffect)this.mobEffectInstance.getEffect().value()).getColor() & 0xFFFFFF;
    }
}

